/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.classifymat.service.impl;

import com.els.base.classifymat.dao.ClassifyMatMapper;
import com.els.base.classifymat.entity.ClassifyMat;
import com.els.base.classifymat.entity.ClassifyMatExample;
import com.els.base.classifymat.service.ClassifyMatService;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultClassifyMatService")
public class ClassifyMatServiceImpl
implements ClassifyMatService {
    @Resource
    protected ClassifyMatMapper classifyMatMapper;

    @CacheEvict(value={"classifyMat"}, allEntries=true)
    public void addObj(ClassifyMat t) {
        this.classifyMatMapper.insertSelective(t);
    }

    @CacheEvict(value={"classifyMat"}, allEntries=true)
    public void deleteObjById(String id) {
        this.classifyMatMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"classifyMat"}, allEntries=true)
    public void modifyObj(ClassifyMat t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.classifyMatMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"classifyMat"}, keyGenerator="redisKeyGenerator")
    public ClassifyMat queryObjById(String id) {
        return this.classifyMatMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"classifyMat"}, keyGenerator="redisKeyGenerator")
    public List<ClassifyMat> queryAllObjByExample(ClassifyMatExample example) {
        return this.classifyMatMapper.selectByExample(example);
    }

    @Cacheable(value={"classifyMat"}, keyGenerator="redisKeyGenerator")
    public PageView<ClassifyMat> queryObjByPage(ClassifyMatExample example) {
        PageView<ClassifyMat> pageView = example.getPageView();
        pageView.setQueryResult(this.classifyMatMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"classifyMat"}, allEntries=true)
    public void addmat(List<ClassifyMat> mat) {
        for (ClassifyMat classifyMat : mat) {
            this.classifyMatMapper.insert(classifyMat);
        }
    }

    @Override
    @Cacheable(value={"classifyMat"}, keyGenerator="redisKeyGenerator")
    public int countByExample(ClassifyMatExample matExample) {
        return this.classifyMatMapper.countByExample(matExample);
    }

    @Override
    @Cacheable(value={"classifyMat"}, keyGenerator="redisKeyGenerator")
    public List<ClassifyMat> queryByTaxId(String id) {
        Assert.isNotBlank((String)id, (String)"\u7a0e\u52a1\u5206\u7c7b\u7801id\u4e0d\u80fd\u4e3a\u7a7a");
        ClassifyMatExample example = new ClassifyMatExample();
        example.createCriteria().andTaxIdEqualTo(id);
        return this.classifyMatMapper.selectByExample(example);
    }

    @Override
    @CacheEvict(value={"classifyMat"}, allEntries=true)
    public void deleteByTaxid(String id) {
        ClassifyMatExample example = new ClassifyMatExample();
        example.createCriteria().andTaxIdEqualTo(id);
        this.classifyMatMapper.deleteByExample(example);
    }

    @CacheEvict(value={"classifyMat"}, allEntries=true)
    public void deleteByExample(ClassifyMatExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.classifyMatMapper.deleteByExample(example);
    }

    @CacheEvict(value={"classifyMat"}, allEntries=true)
    @Transactional
    public void addAll(List<ClassifyMat> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.classifyMatMapper.insertSelective((ClassifyMat)record));
    }
}

