/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.materialrelation.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.materialrelation.dao.MaterialRelationMapper;
import com.els.base.materialrelation.entity.MaterialRelation;
import com.els.base.materialrelation.entity.MaterialRelationExample;
import com.els.base.materialrelation.service.MaterialRelationService;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMaterialRelationService")
public class MaterialRelationServiceImpl
implements MaterialRelationService {
    @Resource
    protected MaterialRelationMapper materialRelationMapper;

    @CacheEvict(value={"materialRelation"}, allEntries=true)
    public void addObj(MaterialRelation t) {
        this.materialRelationMapper.insertSelective(t);
    }

    @CacheEvict(value={"materialRelation"}, allEntries=true)
    public void deleteObjById(String id) {
        this.materialRelationMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialRelation"}, allEntries=true)
    public void modifyObj(MaterialRelation t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.materialRelationMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialRelation"}, keyGenerator="redisKeyGenerator")
    public MaterialRelation queryObjById(String id) {
        return this.materialRelationMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialRelation"}, keyGenerator="redisKeyGenerator")
    public List<MaterialRelation> queryAllObjByExample(MaterialRelationExample example) {
        return this.materialRelationMapper.selectByExample(example);
    }

    @Cacheable(value={"materialRelation"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialRelation> queryObjByPage(MaterialRelationExample example) {
        PageView<MaterialRelation> pageView = example.getPageView();
        pageView.setQueryResult(this.materialRelationMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"materialRelation"}, allEntries=true)
    public void deleteByExample(MaterialRelationExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialRelationMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialRelation"}, allEntries=true)
    @Transactional
    public void addAll(List<MaterialRelation> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.materialRelationMapper.insertSelective((MaterialRelation)record));
    }
}

