/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.taxclassify.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.classifymat.entity.ClassifyMat;
import com.els.base.classifymat.service.ClassifyMatService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.taxclassify.entity.TaxClassify;
import com.els.base.taxclassify.entity.TaxClassifyExample;
import com.els.base.taxclassify.service.TaxClassifyService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5bf9\u8d26\u5355-\u7a0e\u52a1\u5206\u7c7b\u7801\u7ef4\u62a4")
@Controller
@RequestMapping(value={"taxClassify"})
public class TaxClassifyController {
    @Resource
    protected TaxClassifyService taxClassifyService;
    @Resource
    protected ProjectService projectService;
    @Resource
    protected ClassifyMatService classifyMatService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u5bf9\u8d26\u5355-\u7a0e\u52a1\u5206\u7c7b\u7801\u7ef4\u62a4")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody TaxClassify taxClassify) {
        this.taxClassifyService.create(taxClassify, ProjectUtils.getProject(), SpringSecurityUtils.getLoginUser(), CompanyUtils.currentCompany());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5bf9\u8d26\u5355-\u7a0e\u52a1\u5206\u7c7b\u7801\u7ef4\u62a4")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody TaxClassify taxClassify) {
        Assert.isNotBlank((String)taxClassify.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.taxClassifyService.modify(taxClassify, SpringSecurityUtils.getLoginUser(), CompanyUtils.currentCompany());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u5bf9\u8d26\u5355-\u7a0e\u52a1\u5206\u7c7b\u7801\u7ef4\u62a4")
    @RequestMapping(value={"service/delete"})
    @ResponseBody
    public ResponseResult<String> delete(@RequestBody List<TaxClassify> data) {
        Assert.isNotEmpty(data, (String)"\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a");
        this.taxClassifyService.delete(data, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u770b\u5bf9\u8d26\u5355-\u7a0e\u52a1\u5206\u7c7b\u7801\u7ef4\u62a4")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<TaxClassify> findById(String id) {
        Assert.isNotBlank((String)id, (String)"\u4f20\u9012\u7684id\u4e3a\u7a7a!");
        TaxClassify classify = (TaxClassify)this.taxClassifyService.queryObjById(id);
        Assert.isNotNull((Object)classify, (String)"\u6839\u636eid\u67e5\u627e\u7684\u6570\u636e\u4e0d\u5b58\u5728!");
        return ResponseResult.success((Object)classify);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5bf9\u8d26\u5355-\u7a0e\u52a1\u5206\u7c7b\u7801\u7ef4\u62a4")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 TaxClassify", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<TaxClassify>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        TaxClassifyExample example = new TaxClassifyExample();
        example.setPageView((PageView<TaxClassify>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        TaxClassifyExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.taxClassifyService.queryObjByPage((IExample)example);
        List<TaxClassify> taxClassifies = this.getMat(pageData.getQueryResult());
        pageData.setQueryResult(taxClassifies);
        return ResponseResult.success((Object)pageData);
    }

    private List<TaxClassify> getMat(List<TaxClassify> taxClassifies) {
        ArrayList<TaxClassify> taxs = new ArrayList<TaxClassify>();
        if (CollectionUtils.isEmpty(taxClassifies)) {
            return taxs;
        }
        for (TaxClassify taxClassify : taxClassifies) {
            List<ClassifyMat> mats = this.classifyMatService.queryByTaxId(taxClassify.getId());
            taxClassify.setMat(mats);
            taxs.add(taxClassify);
        }
        return taxs;
    }
}

