/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.taxclassify.service.impl;

import com.els.base.classifymat.entity.ClassifyMat;
import com.els.base.classifymat.entity.ClassifyMatExample;
import com.els.base.classifymat.service.ClassifyMatService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.taxclassify.dao.TaxClassifyMapper;
import com.els.base.taxclassify.entity.TaxClassify;
import com.els.base.taxclassify.entity.TaxClassifyExample;
import com.els.base.taxclassify.service.TaxClassifyService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultTaxClassifyService")
public class TaxClassifyServiceImpl
implements TaxClassifyService {
    @Resource
    protected TaxClassifyMapper taxClassifyMapper;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected ClassifyMatService classifyMatService;

    @CacheEvict(value={"taxClassify"}, allEntries=true)
    public void addObj(TaxClassify t) {
        this.taxClassifyMapper.insertSelective(t);
    }

    @CacheEvict(value={"taxClassify"}, allEntries=true)
    public void deleteObjById(String id) {
        this.taxClassifyMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"taxClassify"}, allEntries=true)
    public void modifyObj(TaxClassify t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.taxClassifyMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"taxClassify"}, keyGenerator="redisKeyGenerator")
    public TaxClassify queryObjById(String id) {
        return this.taxClassifyMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"taxClassify"}, keyGenerator="redisKeyGenerator")
    public List<TaxClassify> queryAllObjByExample(TaxClassifyExample example) {
        return this.taxClassifyMapper.selectByExample(example);
    }

    @Cacheable(value={"taxClassify"}, keyGenerator="redisKeyGenerator")
    public PageView<TaxClassify> queryObjByPage(TaxClassifyExample example) {
        PageView<TaxClassify> pageView = example.getPageView();
        pageView.setQueryResult(this.taxClassifyMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"taxClassify"}, allEntries=true)
    public void create(TaxClassify taxClassify, Project project, User user, Company company) {
        Assert.isNotNull((Object)taxClassify, (String)"\u4f20\u9012\u7684\u6570\u636e\u4e3a\u7a7a");
        this.verification(taxClassify);
        this.complete(taxClassify, project, user, company);
        this.classifyMat(taxClassify);
        this.classifyMatService.addmat(taxClassify.getMat());
        this.addObj(taxClassify);
    }

    private void classifyMat(TaxClassify taxClassify) {
        List<ClassifyMat> mat = taxClassify.getMat();
        if (mat.size() == 1) {
            mat.get(0).setId(UUIDGenerator.generateUUID());
            mat.get(0).setTaxId(taxClassify.getId());
            taxClassify.setCustomerMaterialNo(mat.get(0).getCustomerMaterialNo());
            taxClassify.setCustomerMaterialDesc(mat.get(0).getCustomerMaterialDesc());
        } else {
            String customerMaterialNo = "";
            String customerMaterialDesc = "";
            for (ClassifyMat classifyMat : mat) {
                classifyMat.setId(UUIDGenerator.generateUUID());
                classifyMat.setTaxId(taxClassify.getId());
                customerMaterialNo = customerMaterialNo + classifyMat.getCustomerMaterialNo() + ",";
                customerMaterialDesc = customerMaterialDesc + classifyMat.getCustomerMaterialDesc() + ",";
            }
            taxClassify.setCustomerMaterialNo(customerMaterialNo.substring(0, customerMaterialNo.length() - 1));
            taxClassify.setCustomerMaterialDesc(customerMaterialDesc.substring(0, customerMaterialDesc.length() - 1));
        }
        taxClassify.setMat(mat);
    }

    private void complete(TaxClassify taxClassify, Project project, User user, Company currentCompany) {
        String id = UUIDGenerator.generateUUID();
        taxClassify.setId(id);
        taxClassify.setProjectId(project.getId());
        taxClassify.setCreateTime(new Date());
        taxClassify.setIsEnable(Constant.YES_INT);
        Company company = (Company)this.companyService.queryObjById((Object)"20170623111117-7147d39a28ad40e8a");
        taxClassify.setCustomerSrmCode(company.getCompanyCode());
        taxClassify.setCustomerSrmCompanyName(company.getCompanyFullName());
        taxClassify.setCustomerSrmId(company.getId());
        taxClassify.setOperateUserId(user.getId());
        taxClassify.setOperateUserName(user.getNickName());
        taxClassify.setSupCompanyId(currentCompany.getId());
        taxClassify.setSupCompanyName(currentCompany.getCompanyName());
        taxClassify.setSupCompanySrmCode(currentCompany.getCompanyCode());
        taxClassify.setSupCompanySapCode(currentCompany.getCompanySapCode());
        taxClassify.setSupCompanyFullName(currentCompany.getCompanySapCode());
        taxClassify.setUpdateTime(new Date());
    }

    private void verification(TaxClassify taxClassify) {
        Assert.isNotBlank((String)taxClassify.getGoodsandlaborName(), (String)"\u8d27\u7269\u548c\u52b3\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List<ClassifyMat> mat = taxClassify.getMat();
        for (ClassifyMat classifyMat : mat) {
            Assert.isNotBlank((String)classifyMat.getCustomerMaterialNo(), (String)"\u5ba2\u6237\u7269\u6599\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        mat.forEach(i -> {
            ClassifyMatExample matExample = new ClassifyMatExample();
            matExample.createCriteria().andCustomerMaterialNoEqualTo(i.getCustomerMaterialNo());
            if (this.classifyMatService.countByExample(matExample) > 0) {
                throw new CommonException("\u7269\u6599\u7f16\u53f7:" + i.getCustomerMaterialNo() + "\u5df2\u5b58\u5728\u7a0e\u52a1\u5206\u7c7b\u7801,\u8bf7\u68c0\u67e5\u6570\u636e");
            }
        });
    }

    @Override
    @CacheEvict(value={"taxClassify"}, allEntries=true)
    public void modify(TaxClassify taxClassify, User user, Company company) {
        this.verification(taxClassify);
        this.classifyMatService.deleteByTaxid(taxClassify.getId());
        this.deleteObjById(taxClassify.getId());
        this.complete(taxClassify, ProjectUtils.getProject(), user, company);
        this.classifyMat(taxClassify);
        this.classifyMatService.addmat(taxClassify.getMat());
        this.addObj(taxClassify);
    }

    @Override
    @CacheEvict(value={"taxClassify"}, allEntries=true)
    public void delete(List<TaxClassify> data, User user) {
        ArrayList ids = new ArrayList();
        data.forEach(i -> {
            Assert.isNotBlank((String)i.getId(), (String)"\u4f20\u9012\u7684\u6570\u636e\u5b58\u5728id\u4e3a\u7a7a");
            ids.add(i.getId());
        });
        TaxClassifyExample example = new TaxClassifyExample();
        example.createCriteria().andIdIn((List)ids);
        TaxClassify taxClassify = new TaxClassify();
        taxClassify.setIsEnable(Constant.NO_INT);
        taxClassify.setOperateUserId(user.getId());
        taxClassify.setOperateUserName(user.getNickName());
        taxClassify.setUpdateTime(new Date());
        this.taxClassifyMapper.updateByExampleSelective(taxClassify, example);
    }

    @CacheEvict(value={"taxClassify"}, allEntries=true)
    public void deleteByExample(TaxClassifyExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.taxClassifyMapper.deleteByExample(example);
    }

    @CacheEvict(value={"taxClassify"}, allEntries=true)
    @Transactional
    public void addAll(List<TaxClassify> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.taxClassifyMapper.insertSelective((TaxClassify)record));
    }
}

