/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.finance.command;

import com.els.base.bill.entity.Bill;
import com.els.base.bill.entity.BillItem;
import com.els.base.bill.entity.BillItemExample;
import com.els.base.bill.utils.BillStatus;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.finance.command.AbstractCommand;
import com.els.base.finance.command.ComandInvoker;
import com.els.base.finance.deductionSap.ZSRMRFCDZDPZResponse;
import com.els.base.finance.deductionSap.ZSRMRFCRET;
import com.els.base.finance.service.impl.SapBillServiceImpl;
import com.els.base.finance.util.SapException;
import com.els.base.finance.util.SoapServiceRequestText;
import com.els.base.util.BillSapConfUtils;
import com.qqt.service.vo.HttpCallbackResultVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteBackDeductionCommand
extends AbstractCommand<ZSRMRFCDZDPZResponse> {
    private static Logger log = LoggerFactory.getLogger(SapBillServiceImpl.class);
    private static String username = BillSapConfUtils.getServiceUsername();
    private static String password = BillSapConfUtils.getServicePassword();
    private static String serviceUrl = BillSapConfUtils.getDeductionUrl();
    private static String serviceNameSpace = BillSapConfUtils.getDeductionNameSpace();
    private static String serviceMethod = BillSapConfUtils.getDeductionServiceMethod();
    private Bill bill;

    public WriteBackDeductionCommand(Bill bill) {
        this.bill = bill;
    }

    @Override
    public ZSRMRFCDZDPZResponse execute(ComandInvoker context) {
        log.debug("\u3010\u6536\u8d27\u51ed\u8bc1\u51b2\u9500\u56de\u5199sap\u3011serviceUrl\u4e3a[{}]", (Object)serviceUrl);
        SoapServiceRequestText request = new SoapServiceRequestText();
        request.setUrl(serviceUrl);
        if (StringUtils.isNotBlank((String)serviceNameSpace)) {
            request.setNamespace(serviceNameSpace);
        }
        if (!StringUtils.isEmpty((String)username)) {
            String src = username.trim() + ":" + password.trim();
            String encoding = new String(Base64.encodeBase64((byte[])src.getBytes()));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + encoding);
            request.addHeaders(headers);
        }
        request.setMethodName(serviceMethod);
        String xmlParams = this.getXmlParams(this.bill);
        request.setXmlParams(xmlParams);
        log.debug("\u3010\u6536\u8d27\u51ed\u8bc1\u51b2\u9500\u56de\u5199sap\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a[{}]", (Object)xmlParams);
        log.debug("\u3010\u6536\u8d27\u51ed\u8bc1\u51b2\u9500\u56de\u5199sap\u3011\u5f00\u59cb\u8c03\u7528sap\u63a5\u53e3");
        long startTime = System.currentTimeMillis();
        HttpCallbackResultVO vo = request.execute(ZSRMRFCDZDPZResponse.class);
        long endTime = System.currentTimeMillis();
        log.debug("\u3010\u6536\u8d27\u51ed\u8bc1\u51b2\u9500\u56de\u5199sap\u3011\u7ed3\u675f\u8c03\u7528sap\u63a5\u53e3,\u7528\u65f6\u4e3a[{}]", (Object)(endTime - startTime));
        if (vo.getStatus() < 200 || vo.getStatus() > 299) {
            log.error("--> http status {}", (Object)vo.getStatus());
            log.error("--> ReasonPhrase {}", (Object)vo.getReasonPhrase());
            log.error("--> error {}", (Object)vo.getError());
            throw new SapException("sap\u4e1a\u52a1\u5f02\u5e38,\u56de\u5199sap\u5931\u8d25");
        }
        log.debug("\u3010\u6536\u8d27\u51ed\u8bc1\u51b2\u9500\u56de\u5199sap\u3011\u8fd4\u56de\u7ed3\u679c\u4e3a", vo.getResult());
        ZSRMRFCDZDPZResponse respone = (ZSRMRFCDZDPZResponse)vo.getResult();
        if (respone == null) {
            throw new SapException("\u6536\u8d27\u51ed\u8bc1\u51b2\u9500\u56de\u5199sap,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        ZSRMRFCRET outData = respone.getESINFO();
        Assert.isNotNull((Object)outData, (String)"\u6536\u8d27\u51ed\u8bc1\u51b2\u9500\u56de\u5199sap,\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
        log.info("\u3010\u6536\u8d27\u51ed\u8bc1\u51b2\u9500\u56de\u5199sap\u30111\u3001\u83b7\u53d6\u5230\u6570\u636e");
        return respone;
    }

    private String getXmlParams(Bill bill) {
        StringBuilder sbBuffer = new StringBuilder();
        BillItemExample example = new BillItemExample();
        example.createCriteria().andBillIdEqualTo(bill.getId());
        List billItems = this.context.getBillItemService().queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)billItems, (String)"\u5bf9\u8d26\u5355\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        sbBuffer.append("<IT_DZPZ>");
        for (BillItem billItem : billItems) {
            sbBuffer.append("<item>");
            sbBuffer.append("<MANDT></MANDT>");
            sbBuffer.append("<MBLNR>" + billItem.getMaterialVoucherNo() + "</MBLNR>");
            sbBuffer.append("<MJAHR>" + billItem.getAccountingYear() + "</MJAHR>");
            sbBuffer.append("<ZEILE>" + billItem.getMaterialVoucherItemNo() + "</ZEILE>");
            if (Constant.NO_INT.equals(bill.getIsEnable()) || BillStatus.ABOLISH.getCode().equals(bill.getAbolishStatus())) {
                sbBuffer.append("<ZDZBS>0</ZDZBS>");
            } else {
                sbBuffer.append("<ZDZBS>1</ZDZBS>");
            }
            sbBuffer.append("</item>");
        }
        sbBuffer.append("</IT_DZPZ>");
        return sbBuffer.toString();
    }
}

