/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.company.entity.Department;
import com.els.base.company.entity.DepartmentExample;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.project.ProjectUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u90e8\u95e8\u4fe1\u606f")
@Controller
@RequestMapping(value={"department"})
public class DepartmentController {
    @Resource
    protected DepartmentService departmentService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody Department department) {
        department.setCompanyId(CompanyUtils.currentCompanyId());
        department.setProjectId(ProjectUtils.getProjectId());
        this.departmentService.addObj(department);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Department department) {
        if (StringUtils.isBlank((String)department.getId())) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        this.departmentService.modifyObj(department);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        Department department = new Department();
        department.setId(id);
        department.setIsEnable(Constant.NO_INT);
        this.departmentService.modifyObj(department);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5f53\u524d\u516c\u53f8\u7684\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<Department>> findByPage(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="\u4e0a\u7ea7id,\u4e0d\u4f20\u5219\u67e5\u8be2\u9876\u7ea7\u90e8\u95e8") String parentId) {
        DepartmentExample example = new DepartmentExample();
        example.setPageView(new PageView<Department>(pageNo, pageSize));
        DepartmentExample.Criteria cri = example.createCriteria();
        cri.andCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andParentIdIsNull().andIsEnableEqualTo(Constant.YES_INT);
        PageView pageData = this.departmentService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5f53\u524d\u516c\u53f8\u7684\u90e8\u95e8\u4fe1\u606f")
    @RequestMapping(value={"service/findDepartmentTree"})
    @ResponseBody
    public ResponseResult<List<Department>> findDepartmentTree() {
        DepartmentExample example = new DepartmentExample();
        example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andParentIdIsNull().andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        List departmentList = this.departmentService.queryAllObjByExample(example);
        for (Department department : departmentList) {
            department.setSubDepList(this.departmentService.queryByParentId(department.getId()));
        }
        return ResponseResult.success(departmentList);
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u90e8\u95e8\u5185\u7684\u5e10\u53f7")
    @RequestMapping(value={"service/findUsersInDepartment"})
    @ResponseBody
    public ResponseResult<PageView<User>> findUsersInDepartment(@ApiParam(value="\u6240\u5728\u9875", defaultValue="1") @RequestParam(defaultValue="1") int pageNo, @ApiParam(value="\u6bcf\u9875\u6570\u91cf", defaultValue="10") @RequestParam(defaultValue="10") int pageSize, String departmentId) {
        if (StringUtils.isBlank((String)departmentId)) {
            throw new CommonException("Id\u4e3a\u7a7a", "id_is_blank");
        }
        return ResponseResult.success(this.departmentService.queryUsersInDepartmentByPage(pageNo, pageSize, departmentId));
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u90e8\u95e8\u5185\u7684\u5e10\u53f7")
    @RequestMapping(value={"service/addUserIntoDepartment"})
    @ResponseBody
    public ResponseResult<String> addUserIntoDepartment(String userId, String departmentId) {
        Department department = (Department)this.departmentService.queryObjById(departmentId);
        if (department == null) {
            throw new CommonException("\u627e\u4e0d\u5230\u90e8\u95e8", "not_found_depart");
        }
        if (!department.getCompanyId().equals(CompanyUtils.currentCompanyId())) {
            throw new CommonException("\u627e\u4e0d\u5230\u90e8\u95e8", "not_found_depart");
        }
        this.departmentService.addUserIntoDepartment(userId, departmentId);
        return ResponseResult.success();
    }
}

