/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.service.impl;

import com.els.base.company.dao.BankAccountMapper;
import com.els.base.company.entity.BankAccount;
import com.els.base.company.entity.BankAccountExample;
import com.els.base.company.entity.Company;
import com.els.base.company.service.BankAccountService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.utils.Assert;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBankAccountService")
public class BankAccountServiceImpl
implements BankAccountService {
    @Resource
    protected BankAccountMapper bankAccountMapper;

    @CacheEvict(value={"bankAccount"}, allEntries=true)
    public void addObj(BankAccount t) {
        this.bankAccountMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"bankAccount"}, allEntries=true)
    public void addAll(List<BankAccount> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.bankAccountMapper.insertBatch(list);
    }

    @CacheEvict(value={"bankAccount"}, allEntries=true)
    public void deleteObjById(String id) {
        this.bankAccountMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"bankAccount"}, allEntries=true)
    public void deleteByExample(BankAccountExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.bankAccountMapper.deleteByExample(example);
    }

    @CacheEvict(value={"bankAccount"}, allEntries=true)
    public void modifyObj(BankAccount t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.bankAccountMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"bankAccount"}, keyGenerator="redisKeyGenerator")
    public BankAccount queryObjById(String id) {
        return this.bankAccountMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"bankAccount"}, keyGenerator="redisKeyGenerator")
    public List<BankAccount> queryAllObjByExample(BankAccountExample example) {
        return this.bankAccountMapper.selectByExample(example);
    }

    @Cacheable(value={"bankAccount"}, keyGenerator="redisKeyGenerator")
    public PageView<BankAccount> queryObjByPage(BankAccountExample example) {
        PageView<BankAccount> pageView = example.getPageView();
        pageView.setQueryResult(this.bankAccountMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"bankAccount"}, allEntries=true)
    @Transactional
    public void invalid(List<String> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            for (String id : ids) {
                BankAccount bankAccount = new BankAccount();
                bankAccount.setId(id);
                bankAccount.setInvalidFlag("Y");
                bankAccount.setUpdateTime(new Date());
                this.bankAccountMapper.updateByPrimaryKeySelective(bankAccount);
            }
        }
    }

    @Override
    @CacheEvict(value={"bankAccount"}, allEntries=true)
    @Transactional
    public void saveAll(String projectId, String companyId, List<BankAccount> bankAccounts) {
        BankAccountExample example = new BankAccountExample();
        example.createCriteria().andProjectIdEqualTo(projectId).andCompanyIdEqualTo(companyId);
        this.bankAccountMapper.deleteByExample(example);
        if (CollectionUtils.isNotEmpty(bankAccounts)) {
            for (BankAccount bankAccount : bankAccounts) {
                bankAccount.setId(UUIDGenerator.generateUUID());
                bankAccount.setProjectId(projectId);
                bankAccount.setCompanyId(companyId);
                bankAccount.setInvalidFlag("N");
                bankAccount.setCreateTime(new Date());
            }
            this.bankAccountMapper.insertBatch(bankAccounts);
        }
    }

    @Override
    public int isFinish(Project project, Company company) {
        BankAccountExample example = new BankAccountExample();
        example.createCriteria().andProjectIdEqualTo(project.getId()).andCompanyIdEqualTo(company.getId()).andInvalidFlagEqualTo("N");
        return this.bankAccountMapper.countByExample(example) > 0 ? 1 : 0;
    }
}

