/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.utils;

import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyTypeEnum;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.utils.reflect.ReflectUtils;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FinishFlagUtils {
    private static Logger logger = LoggerFactory.getLogger(FinishFlagUtils.class);

    public static Integer getFinishFlag(Company company) {
        Assert.isNotBlank((String)company.getFirstCompanyType(), (String)"\u4f01\u4e1a\u7684\u4f9b\u5e94\u5546\u670d\u52a1\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            Class<Company> objectClass = Company.class;
            Object[] fields = objectClass.getDeclaredFields();
            if (ArrayUtils.isEmpty((Object[])fields)) {
                logger.info("\u5c5e\u6027\u6570\u7ec4\u4e3anull\uff0c\u8fd4\u56defalse");
                return Constant.NO_INT;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(FinishFlagUtils.exculdeFieldNames());
            String firstCompanyType = company.getFirstCompanyType();
            if (firstCompanyType.equals(CompanyTypeEnum.AGENT.getCode())) {
                list.add("plantArea");
                list.add("plantUseRate");
                list.add("workerNumber");
                list.add("productCapacity");
                list.add("monthlyCapacity");
            } else if (firstCompanyType.equals(CompanyTypeEnum.MANUFACTURER.getCode())) {
                list.add("actingBrand");
                list.add("agentTime");
                list.add("actingProducts");
                list.add("isFieldService");
                list.add("plantArea");
                list.add("plantUseRate");
                list.add("productCapacity");
            } else {
                list.add("actingBrand");
                list.add("agentTime");
                list.add("actingProducts");
                list.add("isFieldService");
                list.add("monthlyCapacity");
                list.add("competitionProducts");
            }
            for (Object field : fields) {
                ((Field)field).setAccessible(true);
                if (list.contains(((Field)field).getName())) continue;
                if (((Field)field).get(company) == null) {
                    if (null != ((Field)field).getAnnotation(ApiModelProperty.class)) {
                        throw new CommonException(((Field)field).getAnnotation(ApiModelProperty.class).value() + "\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6b63\u786e\u586b\u5199\u4fe1\u606f\uff0c\u8c22\u8c22\uff01");
                    }
                    throw new CommonException("\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u6ca1\u586b\u5199\u5b8c\u6574\uff0c\u8bf7\u6b63\u786e\u586b\u5199\u4fe1\u606f\uff0c\u8c22\u8c22\uff01");
                }
                if (!((Field)field).getType().equals(String.class)) continue;
                String val = (String)ReflectUtils.getValue((Object)company, (String)((Field)field).getName());
                logger.debug("\u5c5e\u6027[{}]\u7684\u503c\u662f[{}]", (Object)((Field)field).getName(), (Object)val);
                if (!StringUtils.isBlank((String)val)) continue;
                logger.debug("\u5b57\u7b26\u4e32\u7684\u503c\u4e3a\u7a7a\uff0c\u8fd4\u56defalse");
                if (null != ((Field)field).getAnnotation(ApiModelProperty.class)) {
                    throw new CommonException(((Field)field).getAnnotation(ApiModelProperty.class).value() + "\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6b63\u786e\u586b\u5199\u4fe1\u606f\uff0c\u8c22\u8c22\uff01");
                }
                throw new CommonException("\u4f01\u4e1a\u57fa\u672c\u4fe1\u606f\u6ca1\u586b\u5199\u5b8c\u6574\uff0c\u8bf7\u6b63\u786e\u586b\u5199\u4fe1\u606f\uff0c\u8c22\u8c22\uff01");
            }
        }
        catch (IllegalAccessException e) {
            throw new CommonException("\u68c0\u67e5\u662f\u5426\u586b\u5b8c\u8d44\u6599\u5931\u8d25");
        }
        return Constant.YES_INT;
    }

    protected static List<String> exculdeFieldNames() {
        ArrayList<String> filedNameList = new ArrayList<String>();
        filedNameList.add("id");
        filedNameList.add("extInfo");
        filedNameList.add("password");
        filedNameList.add("partnerRoleName");
        filedNameList.add("partnerRoleCode");
        filedNameList.add("supplierTemporaryCode");
        filedNameList.add("userList");
        filedNameList.add("companyAddressList");
        filedNameList.add("parentId");
        filedNameList.add("projectId");
        filedNameList.add("industry");
        filedNameList.add("subIndustry");
        filedNameList.add("companyCode");
        filedNameList.add("companySapCode");
        filedNameList.add("companyType");
        filedNameList.add("businessScop");
        filedNameList.add("taxCert");
        filedNameList.add("organzationCert");
        filedNameList.add("businessLicence");
        filedNameList.add("country");
        filedNameList.add("province");
        filedNameList.add("city");
        filedNameList.add("mobilephone");
        filedNameList.add("email");
        filedNameList.add("website");
        filedNameList.add("remark");
        filedNameList.add("contacts");
        filedNameList.add("status");
        filedNameList.add("isEnable");
        filedNameList.add("externalManufacturer");
        filedNameList.add("purchasingStaff");
        filedNameList.add("groupCode");
        filedNameList.add("delegateType");
        filedNameList.add("industrialType");
        filedNameList.add("reconciliationAccountCode");
        filedNameList.add("reconciliationAccountName");
        filedNameList.add("payConditionsDesc");
        filedNameList.add("internationalTradeCondition");
        filedNameList.add("salesman");
        filedNameList.add("salesmanPhone");
        filedNameList.add("invoiceVerify");
        filedNameList.add("automaticPurchaseOrder");
        filedNameList.add("purchasingGroup");
        filedNameList.add("plannedDeliveryTime");
        filedNameList.add("supplyProperties");
        filedNameList.add("createTime");
        filedNameList.add("firstCompanyTypeExplain");
        filedNameList.add("secondCompanyTypeExplain");
        filedNameList.add("approveTime");
        filedNameList.add("approveStatus");
        filedNameList.add("approveUserName");
        filedNameList.add("corporationLegalPerson");
        filedNameList.add("secondCompanyType");
        filedNameList.add("firstCompanyType");
        filedNameList.add("classificationThree");
        filedNameList.add("grade");
        filedNameList.add("businessScope");
        filedNameList.add("productionAddress");
        filedNameList.add("reducedRate");
        return filedNameList;
    }
}

