/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.utils;

import com.els.base.core.exception.CommonException;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

public abstract class SectionUtils {
    private static final ThreadLocal<List<Section>> SECTION_HOLDER = new ThreadLocal();

    public static void add(Section section) {
        SectionUtils.add(section, false);
    }

    public static void add(Section section, boolean intersectable) {
        List<Section> sectionList = SECTION_HOLDER.get();
        if (sectionList == null) {
            sectionList = new LinkedList<Section>();
            sectionList.add(section);
            SECTION_HOLDER.set(sectionList);
            return;
        }
        if (!intersectable) {
            sectionList.forEach(tmp -> {
                Section toSmaller;
                if (tmp.getFrom() == null && tmp.getTo() == null || tmp.getTo() == null && section.getTo() == null) {
                    throw new SectionIntersectException((Section)tmp, section);
                }
                Section toBigger = tmp.getTo() == null || section.getTo() != null && tmp.getTo().compareTo(section.getTo()) == 1 ? tmp : section;
                Section section2 = toSmaller = toBigger == tmp ? section : tmp;
                if (toBigger.getFrom() == null || toSmaller.getTo().compareTo(toBigger.getFrom()) == 1) {
                    throw new SectionIntersectException((Section)tmp, section);
                }
            });
        }
        sectionList.add(section);
    }

    public static void clear() {
        Optional.ofNullable(SECTION_HOLDER.get()).ifPresent(List::clear);
    }

    public static class SectionIntersectException
    extends CommonException {
        private static final long serialVersionUID = 1L;
        private Section section1;
        private Section section2;

        public SectionIntersectException(Section section1, Section section2) {
            super("\u533a\u95f4" + section1 + "\u4e0e\u533a\u95f4" + section2 + "\u76f8\u4ea4");
            this.section1 = section1;
            this.section2 = section2;
        }

        public Section getSection1() {
            return this.section1;
        }

        public void setSection1(Section section1) {
            this.section1 = section1;
        }

        public Section getSection2() {
            return this.section2;
        }

        public void setSection2(Section section2) {
            this.section2 = section2;
        }
    }

    public static class SectionStartGreatThanEndException
    extends CommonException {
        private static final long serialVersionUID = 1L;
        BigDecimal from;
        BigDecimal to;

        public SectionStartGreatThanEndException(BigDecimal from, BigDecimal to) {
            super("\u533a\u95f4\u7684\u5f00\u59cb\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f:[" + from + ", " + to + ")");
            this.from = from;
            this.to = to;
        }

        public BigDecimal getFrom() {
            return this.from;
        }

        public void setFrom(BigDecimal from) {
            this.from = from;
        }

        public BigDecimal getTo() {
            return this.to;
        }

        public void setTo(BigDecimal to) {
            this.to = to;
        }
    }

    public static class Section {
        private BigDecimal from;
        private BigDecimal to;

        private Section(BigDecimal from, BigDecimal to) {
            if (from == null && to == null) {
                throw new IllegalArgumentException("\u533a\u95f4\u7684\u5f00\u59cb\u4e0e\u7ed3\u675f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            if (from != null && to != null && to.compareTo(from) != 1) {
                throw new SectionStartGreatThanEndException(from, to);
            }
            this.from = from;
            this.to = to;
        }

        public static Section of(BigDecimal from, BigDecimal to) {
            return new Section(from, to);
        }

        public static Section of(BigDecimal from, Double to) {
            return new Section(from, new BigDecimal(to));
        }

        public static Section of(BigDecimal from, Long to) {
            return new Section(from, new BigDecimal(to));
        }

        public static Section of(BigDecimal from, Integer to) {
            return new Section(from, new BigDecimal(to));
        }

        public static Section of(Double from, BigDecimal to) {
            return new Section(new BigDecimal(from), to);
        }

        public static Section of(Double from, Double to) {
            return new Section(new BigDecimal(from), new BigDecimal(to));
        }

        public static Section of(Double from, Long to) {
            return new Section(new BigDecimal(from), new BigDecimal(to));
        }

        public static Section of(Double from, Integer to) {
            return new Section(new BigDecimal(from), new BigDecimal(to));
        }

        public static Section of(Long from, BigDecimal to) {
            return new Section(new BigDecimal(from), to);
        }

        public static Section of(Long from, Double to) {
            return new Section(new BigDecimal(from), new BigDecimal(to));
        }

        public static Section of(Long from, Long to) {
            return new Section(new BigDecimal(from), new BigDecimal(to));
        }

        public static Section of(Long from, Integer to) {
            return new Section(new BigDecimal(from), new BigDecimal(to));
        }

        public static Section of(Integer from, BigDecimal to) {
            return new Section(new BigDecimal(from), to);
        }

        public static Section of(Integer from, Double to) {
            return new Section(new BigDecimal(from), new BigDecimal(to));
        }

        public static Section of(Integer from, Long to) {
            return new Section(new BigDecimal(from), new BigDecimal(to));
        }

        public static Section of(Integer from, Integer to) {
            return new Section(new BigDecimal(from), new BigDecimal(to));
        }

        public BigDecimal getFrom() {
            return this.from;
        }

        public void setFrom(BigDecimal from) {
            this.from = from;
        }

        public BigDecimal getTo() {
            return this.to;
        }

        public void setTo(BigDecimal to) {
            this.to = to;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.from != null ? "[" : "(");
            builder.append(this.from != null ? this.from : "-\u221e");
            builder.append(", ");
            builder.append(this.to != null ? this.to : "+\u221e");
            builder.append(this.to != null ? "]" : ")");
            return builder.toString();
        }
    }
}

