/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.company.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.msg.mail.entity.MailAccountExample;
import com.els.base.msg.mail.service.MailAccountService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u6d88\u606f\u7ba1\u7406-\u90ae\u4ef6-\u5e10\u53f7\u4fe1\u606f"})
@Controller
@RequestMapping(value={"mail"})
public class MailAccountForCompanyController {
    @Resource
    protected MailAccountService mailAccountService;

    @ApiOperation(httpMethod="POST", value="\u9884\u521b\u5efa\u90ae\u4ef6\u4fe1\u606f")
    @RequestMapping(value={"service/createPreveiw"})
    @ResponseBody
    public ResponseResult<MailAccount> createPreveiw() {
        MailAccount mailAccount = new MailAccount();
        mailAccount.setProjectId(ProjectUtils.getProjectId());
        mailAccount.setCompanyId(CompanyUtils.currentCompanyId());
        mailAccount.setCompanyName(CompanyUtils.currentCompany().getCompanyFullName());
        mailAccount.setUserId(SpringSecurityUtils.getLoginUserId());
        mailAccount.setUserLoginName(SpringSecurityUtils.getLoginUserName());
        mailAccount.setUserName(SpringSecurityUtils.getLoginUser().getNickName());
        mailAccount.setMailAddress(SpringSecurityUtils.getLoginUser().getEmail());
        mailAccount.setStmpServerPort(Integer.valueOf(25));
        mailAccount.setStmpServerIsSsl(Constant.NO_INT);
        return ResponseResult.success((Object)mailAccount);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u90ae\u4ef6\u4fe1\u606f")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody(required=true) MailAccount mailAccount) {
        if (mailAccount.getMailAddress() != null && mailAccount.getMailAddress().length() > 255 || mailAccount.getStmpServerHost() != null && mailAccount.getStmpServerHost().length() > 255 || mailAccount.getRemark() != null && mailAccount.getRemark().getBytes().length > 255 || mailAccount.getPassword() != null && mailAccount.getPassword().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        mailAccount.setProjectId(ProjectUtils.getProjectId());
        mailAccount.setCompanyId(CompanyUtils.currentCompanyId());
        mailAccount.setCompanyName(CompanyUtils.currentCompany().getCompanyFullName());
        mailAccount.setCreateUser(SpringSecurityUtils.getLoginUserName());
        this.mailAccountService.addObj((Serializable)mailAccount);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u90ae\u4ef6\u4fe1\u606f")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MailAccount mailAccount) {
        if (StringUtils.isBlank((String)mailAccount.getId())) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        if (mailAccount.getMailAddress() != null && mailAccount.getMailAddress().length() > 255 || mailAccount.getStmpServerHost() != null && mailAccount.getStmpServerHost().length() > 255 || mailAccount.getRemark() != null && mailAccount.getRemark().getBytes().length > 255 || mailAccount.getPassword() != null && mailAccount.getPassword().length() > 255) {
            throw new CommonException("\u8f93\u5165\u7684\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        this.mailAccountService.modifyObj((Serializable)mailAccount);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u90ae\u4ef6\u4fe1\u606f")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.mailAccountService.deleteObjById((Object)id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u8bbe\u7f6e\u8be5\u90ae\u7bb1\u5e10\u53f7\u4e3a\u9ed8\u8ba4")
    @RequestMapping(value={"service/setDefalut"})
    @ResponseBody
    public ResponseResult<String> setDefalut(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.mailAccountService.setMailAccountAsDefault(CompanyUtils.currentCompanyId(), id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u90ae\u4ef6\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MailAccount", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MailAccount>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MailAccountExample example = new MailAccountExample();
        example.setPageView(new PageView(pageNo, pageSize));
        MailAccountExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC");
        PageView pageData = this.mailAccountService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

