/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.datacleaning.service.impl;

import com.els.base.company.dao.DepartmentMapper;
import com.els.base.company.entity.Department;
import com.els.base.company.enums.DepartmentTypeEnum;
import com.els.base.company.service.DepartmentService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.project.ProjectExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.datacleaning.dao.BranchInfosMapper;
import com.els.base.datacleaning.dto.CompanyInfoDTO;
import com.els.base.datacleaning.entity.BranchInfos;
import com.els.base.datacleaning.entity.BranchInfosExample;
import com.els.base.datacleaning.service.BranchInfosService;
import com.els.base.datacleaning.utils.DataCleaningUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultBranchInfosService")
public class BranchInfosServiceImpl
implements BranchInfosService {
    @Resource
    protected BranchInfosMapper branchInfosMapper;
    @Resource
    private DepartmentService departmentService;
    @Resource
    private DepartmentMapper departmentMapper;
    private Map<String, CompanyInfoDTO> map;
    private String companyId;
    private String projectId;
    @Resource
    private ProjectService projectService;
    private StringBuffer sb = new StringBuffer();

    @CacheEvict(value={"branchInfos"}, allEntries=true)
    public void addObj(BranchInfos t) {
        this.branchInfosMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"branchInfos"}, allEntries=true)
    public void addAll(List<BranchInfos> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.branchInfosMapper.insertBatch(list);
    }

    @CacheEvict(value={"branchInfos"}, allEntries=true)
    public void deleteObjById(String id) {
        this.branchInfosMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"branchInfos"}, allEntries=true)
    public void deleteByExample(BranchInfosExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.branchInfosMapper.deleteByExample(example);
    }

    @CacheEvict(value={"branchInfos"}, allEntries=true)
    public void modifyObj(BranchInfos t) {
        Assert.isNotNull((Object)t.getBranchid(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.branchInfosMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"branchInfos"}, keyGenerator="redisKeyGenerator")
    public BranchInfos queryObjById(String id) {
        return this.branchInfosMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"branchInfos"}, keyGenerator="redisKeyGenerator")
    public List<BranchInfos> queryAllObjByExample(BranchInfosExample example) {
        return this.branchInfosMapper.selectByExample(example);
    }

    @Cacheable(value={"branchInfos"}, keyGenerator="redisKeyGenerator")
    public PageView<BranchInfos> queryObjByPage(BranchInfosExample example) {
        PageView<BranchInfos> pageView = example.getPageView();
        pageView.setQueryResult(this.branchInfosMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"branchInfo"}, allEntries=true)
    public String branchDataCleaning(String companyId) {
        List projects;
        List<BranchInfos> branchInfos = this.queryAllObjByExample(new BranchInfosExample());
        if (CollectionUtils.isEmpty(branchInfos)) {
            Assert.isNotNull(null, (String)"\u540c\u6b65\u6570\u636e\u4e3a\u7a7a\u3002");
        }
        if (CollectionUtils.isEmpty((Collection)(projects = this.projectService.queryAllObjByExample((IExample)new ProjectExample())))) {
            throw new CommonException("\u5c1a\u672a\u627e\u5230\u9879\u76ee\u4fe1\u606f");
        }
        this.projectId = ((Project)projects.get(0)).getId();
        List<CompanyInfoDTO> companyInfoDTOS = this.branchInfosMapper.getAllCompanyInfo();
        this.map = companyInfoDTOS.stream().collect(Collectors.toMap(CompanyInfoDTO::getCompanyNo, a -> a, (k1, k2) -> k1));
        this.companyId = companyId;
        ArrayList result = new ArrayList();
        branchInfos.forEach(branchInfo -> {
            if (StringUtils.isBlank((String)branchInfo.getParent())) {
                result.add(DataCleaningUtils.getChildrens(branchInfo, branchInfos));
            }
        });
        result.forEach(branchInfo -> this.setDepartmentParent((BranchInfos)branchInfo, null));
        System.out.println("\u6709\u95ee\u9898\u7684\u6761\u6570id\u4e3a\uff1a");
        System.out.println(this.sb.toString());
        return this.sb.toString();
    }

    private void setDepartmentParent(BranchInfos branchInfo, String parent) {
        Department department = new Department();
        department.setId(branchInfo.getBranchid());
        if (DepartmentTypeEnum.ACCOUNT_SET.getCode().equals(branchInfo.getGrade())) {
            department.setDepartmentCode(this.map.get(branchInfo.getCompanyNo()).getBusinessBook());
            department.setDescription(this.map.get(branchInfo.getCompanyNo()).getDescription());
        } else {
            department.setDepartmentCode(branchInfo.getBranchid());
        }
        department.setParentId(branchInfo.getParent());
        department.setProjectId(this.projectId);
        department.setCompanyId(this.companyId);
        department.setDepartmentName(branchInfo.getName());
        department.setDepartmentType(branchInfo.getGrade());
        department.setIsEnable(Constant.YES_INT);
        if (StringUtils.isNotBlank((String)parent)) {
            department.setParent(parent + "," + department.getId());
        } else {
            department.setParent(department.getId());
        }
        if (this.departmentMapper.insert(department) < 1) {
            this.sb.append(branchInfo.getBranchid() + "\n");
        }
        if (null != branchInfo.getSubBranchList() && branchInfo.getSubBranchList().size() > 0) {
            branchInfo.getSubBranchList().forEach(dep -> this.setDepartmentParent((BranchInfos)dep, department.getParent()));
        }
    }
}

