/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.datacleaning.service.impl;

import com.els.base.company.dao.DepartmentMapper;
import com.els.base.company.entity.Department;
import com.els.base.company.entity.DepartmentExample;
import com.els.base.company.enums.DepartmentTypeEnum;
import com.els.base.company.service.DepartmentService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.datacleaning.dao.DepartmentInfoMapper;
import com.els.base.datacleaning.entity.DepartmentInfo;
import com.els.base.datacleaning.entity.DepartmentInfoExample;
import com.els.base.datacleaning.service.DepartmentInfoService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultDepartmentInfoService")
public class DepartmentInfoServiceImpl
implements DepartmentInfoService {
    @Resource
    protected DepartmentInfoMapper departmentInfoMapper;
    @Resource
    private DepartmentService departmentService;
    @Resource
    private DepartmentMapper departmentMapper;
    StringBuffer sb = new StringBuffer();
    private Map<String, DepartmentInfo> map = null;

    @CacheEvict(value={"departmentInfo"}, allEntries=true)
    public void addObj(DepartmentInfo t) {
        this.departmentInfoMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"departmentInfo"}, allEntries=true)
    public void addAll(List<DepartmentInfo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        this.departmentInfoMapper.insertBatch(list);
    }

    @CacheEvict(value={"departmentInfo"}, allEntries=true)
    public void deleteObjById(String id) {
        this.departmentInfoMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"departmentInfo"}, allEntries=true)
    public void deleteByExample(DepartmentInfoExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.departmentInfoMapper.deleteByExample(example);
    }

    @CacheEvict(value={"departmentInfo"}, allEntries=true)
    public void modifyObj(DepartmentInfo t) {
        Assert.isNotNull((Object)t.getDeptNo(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.departmentInfoMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"departmentInfo"}, keyGenerator="redisKeyGenerator")
    public DepartmentInfo queryObjById(String id) {
        return this.departmentInfoMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"departmentInfo"}, keyGenerator="redisKeyGenerator")
    public List<DepartmentInfo> queryAllObjByExample(DepartmentInfoExample example) {
        return this.departmentInfoMapper.selectByExample(example);
    }

    @Cacheable(value={"departmentInfo"}, keyGenerator="redisKeyGenerator")
    public PageView<DepartmentInfo> queryObjByPage(DepartmentInfoExample example) {
        PageView<DepartmentInfo> pageView = example.getPageView();
        pageView.setQueryResult(this.departmentInfoMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public String branchDataCleaningDepartment() {
        List departments = this.departmentService.queryAllObjByExample((IExample)new DepartmentExample());
        ArrayList resultDepartment = new ArrayList();
        departments.forEach(department -> resultDepartment.add(this.getChildrens((Department)department, departments)));
        List<DepartmentInfo> departmentInfos = this.departmentInfoMapper.getList();
        Map<String, List<DepartmentInfo>> groupDepartmentInfo = departmentInfos.stream().collect(Collectors.groupingBy(DepartmentInfo::getFinBranchCode));
        for (int i = 0; i < resultDepartment.size(); ++i) {
            Department department2 = (Department)resultDepartment.get(i);
            if (!groupDepartmentInfo.containsKey(department2.getId())) continue;
            List<DepartmentInfo> departmentInfoOpera = this.getSubList(groupDepartmentInfo.get(department2.getId()));
            for (DepartmentInfo departmentInfo : departmentInfoOpera) {
                this.updateDepartmentByParent(departmentInfo, department2.getParent(), department2);
            }
        }
        System.out.println("\u6709\u95ee\u9898\u8bb0\u5f55" + this.sb.toString());
        return this.sb.toString();
    }

    private List<DepartmentInfo> getSubList(List<DepartmentInfo> departmentInfos) {
        this.map = new HashMap<String, DepartmentInfo>();
        Collections.sort(departmentInfos, Comparator.comparing(DepartmentInfo::getDeptNo));
        ArrayList<DepartmentInfo> result = new ArrayList<DepartmentInfo>();
        departmentInfos.forEach(departmentInfo -> {
            if (this.map != null && !this.map.containsKey(departmentInfo.getDeptNo())) {
                result.add(this.treeDepartmentInfo((DepartmentInfo)departmentInfo, departmentInfos));
            }
        });
        return result;
    }

    private DepartmentInfo treeDepartmentInfo(DepartmentInfo module, List<DepartmentInfo> departmentInfos) {
        this.map.put(module.getDeptNo(), module);
        ArrayList<DepartmentInfo> childNodes = new ArrayList<DepartmentInfo>();
        departmentInfos.forEach(departmentInfo -> {
            if (StringUtils.isNotBlank((String)departmentInfo.getParentDept()) && departmentInfo.getParentDept().equals(module.getDeptNo())) {
                childNodes.add(this.treeDepartmentInfo((DepartmentInfo)departmentInfo, departmentInfos));
            }
        });
        module.setSubList(childNodes);
        return module;
    }

    private void updateDepartmentByParent(DepartmentInfo departmentInfo, String parent, Department dd) {
        Department department = new Department();
        department.setId(departmentInfo.getDeptNo());
        if (StringUtils.isNotBlank((String)parent)) {
            department.setParentId(dd.getId());
            department.setParent(dd.getParent() + "," + department.getId());
        } else {
            department.setParentId(departmentInfo.getParentDept());
            department.setParent(parent + department.getId());
        }
        department.setProjectId(dd.getProjectId());
        department.setCompanyId(dd.getCompanyId());
        department.setDepartmentName(departmentInfo.getDeptName());
        department.setDepartmentCode(departmentInfo.getDeptNo());
        department.setDepartmentType(DepartmentTypeEnum.DEPARTMENT.getCode());
        department.setParent(dd.getParent() + "," + departmentInfo.getDeptNo());
        department.setIsEnable(Constant.YES_INT);
        DepartmentExample departmentExample = new DepartmentExample();
        departmentExample.createCriteria().andIdEqualTo(department.getId());
        if (this.departmentMapper.countByExample(departmentExample) > 0) {
            System.out.println("\u4e3b\u952e\u5df2\u5b58\u5728=>" + department.getId());
            this.sb.append("\u4e3b\u952e\u5df2\u5b58\u5728=>" + department.getId() + "\n");
        } else if (this.departmentMapper.insert(department) < 1) {
            this.sb.append(department.getId() + "\n");
        }
        if (null != departmentInfo.getSubList() && departmentInfo.getSubList().size() > 0) {
            departmentInfo.getSubList().forEach(dep -> this.updateDepartmentByParent((DepartmentInfo)dep, departmentInfo.getParentDept(), department));
        }
    }

    private Department getChildrens(Department module, List<Department> departments) {
        ArrayList<Department> childNodes = new ArrayList<Department>();
        departments.forEach(department -> {
            if (StringUtils.isNotBlank((String)department.getParentId()) && department.getParentId().equals(module.getId())) {
                childNodes.add(this.getChildrens((Department)department, departments));
            }
        });
        module.setSubDepList(childNodes);
        return module;
    }
}

