/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.datacleaning.service.impl;

import com.els.base.company.entity.CompanyUserRef;
import com.els.base.company.entity.Department;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.company.service.DepartmentService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.project.Project;
import com.els.base.core.entity.project.ProjectExample;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.project.ProjectService;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.datacleaning.dao.BranchInfosMapper;
import com.els.base.datacleaning.dto.UserInfoDto;
import com.els.base.datacleaning.service.UserInfoService;
import com.els.base.datacleaning.web.vo.UserDepartmentRefVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class UserInfoServiceImpl
implements UserInfoService {
    private StringBuffer sb = null;
    private String password = "123456789";
    @Resource
    private BranchInfosMapper branchInfosMapper;
    @Resource
    private UserService userService;
    @Resource
    private ProjectService projectService;
    @Resource
    private DepartmentService departmentService;
    @Resource
    private CompanyUserRefService companyUserRefService;

    @Override
    public String branchDataCleaningUserInfo(String companyId) {
        this.sb = new StringBuffer();
        List<UserInfoDto> userInfoDtos = this.branchInfosMapper.getAllUserInfo();
        if (CollectionUtils.isEmpty(userInfoDtos)) {
            throw new CommonException("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728!");
        }
        List projects = this.projectService.queryAllObjByExample((IExample)new ProjectExample());
        if (CollectionUtils.isEmpty((Collection)projects)) {
            throw new CommonException("\u5c1a\u672a\u627e\u5230\u9879\u76ee\u4fe1\u606f");
        }
        String projectCode = ((Project)projects.get(0)).getProjectCode();
        String projectId = ((Project)projects.get(0)).getId();
        for (UserInfoDto userInfoDto : userInfoDtos) {
            User user = new User();
            user.setLoginName(this.getLoginName(userInfoDto.getEmail()));
            user.setNickName(userInfoDto.getName());
            user.setPassword(this.password);
            user.setProjectCode(projectCode);
            user.setGender(userInfoDto.getSexCode());
            user.setEmail(userInfoDto.getEmail());
            user.setWorkNum(userInfoDto.getWorkNum());
            user.setIsEnable(Constant.YES_INT);
            this.userService.addObj((Serializable)user);
            List<UserDepartmentRefVO> userDepartmentRefVOS = this.branchInfosMapper.getUserDepartmentRefList(userInfoDto.getWorkNum());
            if (CollectionUtils.isEmpty(userDepartmentRefVOS)) continue;
            for (UserDepartmentRefVO userDepartmentRefVO : userDepartmentRefVOS) {
                Department department = (Department)this.departmentService.queryObjById(userDepartmentRefVO.getDeptNo());
                if (null == department) continue;
                CompanyUserRef companyUserRef = new CompanyUserRef();
                companyUserRef.setProjectId(projectId);
                companyUserRef.setCompanyId(companyId);
                companyUserRef.setDepartmentId(userDepartmentRefVO.getDeptNo());
                companyUserRef.setUserId(user.getId());
                companyUserRef.setCreateTime(new Date());
                this.companyUserRefService.addObj(companyUserRef);
            }
        }
        return null;
    }

    private String getLoginName(String email) {
        String[] strs;
        StringBuffer result = new StringBuffer();
        String str = email.split("@")[0];
        for (String s : strs = str.split("\\.")) {
            result.append(s);
        }
        return result.toString();
    }
}

