/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.datacleaning.web.controller;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.datacleaning.entity.BranchInfos;
import com.els.base.datacleaning.entity.BranchInfosExample;
import com.els.base.datacleaning.service.BranchInfosService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u673a\u6784\u4ee3\u7801\u8868")
@Controller
@RequestMapping(value={"branchInfos"})
public class BranchInfosController {
    @Resource
    protected BranchInfosService branchInfosService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u673a\u6784\u4ee3\u7801\u8868")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody BranchInfos branchInfos) {
        this.branchInfosService.addObj(branchInfos);
        return ResponseResult.success((Object)branchInfos.getBranchid());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u673a\u6784\u4ee3\u7801\u8868")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody BranchInfos branchInfos) {
        Assert.isNotNull((Object)branchInfos.getBranchid(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.branchInfosService.modifyObj(branchInfos);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u673a\u6784\u4ee3\u7801\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        BranchInfosExample example = new BranchInfosExample();
        example.createCriteria().andBranchidIn((List)ids);
        this.branchInfosService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u673a\u6784\u4ee3\u7801\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 BranchInfos", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<BranchInfos>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        BranchInfosExample example = new BranchInfosExample();
        example.setPageView((PageView<BranchInfos>)new PageView(pageNo, pageSize));
        BranchInfosExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.branchInfosService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="GET", value="\u6e05\u7406\u673a\u6784\u4fe1\u606f")
    @RequestMapping(value={"service/branchDataCleaning"})
    @ResponseBody
    public ResponseResult<String> branchDataCleaning() {
        return ResponseResult.success((Object)this.branchInfosService.branchDataCleaning(CompanyUtils.currentCompanyId()));
    }
}

