package com.els.kangni.contract.manage.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.kangni.contract.manage.emum.ContractStatus;
import com.els.kangni.contract.manage.entity.ContractManage;
import com.els.kangni.contract.manage.entity.ContractManageExample;
import com.els.kangni.contract.manage.service.ContractManageService;
import com.els.kangni.contract.manage.utils.ContractPrintUtils;
import com.els.kangni.contract.template.entity.ContractTemplate;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="T_CONTRACT_MANAGE")
@Controller
@RequestMapping("contractManage")
public class ContractManageController {
    @Resource
    protected ContractManageService contractManageService;

        @ApiOperation(httpMethod="POST", value="根据模板创建")
        @RequestMapping("service/createByTemplate")
        @ResponseBody
        public ResponseResult<String> createByTemplate(@RequestBody ContractManage contractManage	,@RequestBody ContractTemplate contractTemplate) {
        	if (contractTemplate.getAuditStatus()!=3) {
        		throw new CommonException("必须审核通过的模板才能创建");
			}
        	contractManage.setIsEnable(1);
        	contractManage.setCreateUserTime(new Date());
        	contractManage.setUpdateUserTime(new Date());
        	User loginUser = SpringSecurityUtils.getLoginUser();
            String username = loginUser.getUsername();
            contractManage.setCreateUserName(username);
            contractManage.setIssend(0);
            contractManage.setContractStatus(ContractStatus.CREATE.getCode());
            contractManage.setTemplateNo(contractTemplate.getTemplateNo());
            contractManage.setTemplateType(contractTemplate.getTemplateType());
            contractManage.setTemplateVersion(contractTemplate.getVersion());
            this.contractManageService.addObj(contractManage);
            return ResponseResult.success();
        }
        
        @ApiOperation(httpMethod="POST", value="创建T_CONTRACT_MANAGE")
        @RequestMapping("service/create")
        @ResponseBody
        public ResponseResult<String> create(@RequestBody ContractManage contractManage	) {
        	 Assert.isNotBlank(contractManage.getTemplateNo(), "模板编号不能为空");
        	Assert.isNotBlank(contractManage.getTemplateType(), "模板类型不能为空");
        	 Assert.isNotBlank(contractManage.getVersion(), "模板版本不能为空");
        	 Assert.isNotBlank(contractManage.getContractName(), "合同名称不能为空");
        	 Assert.isNotBlank(contractManage.getSupCompanyName(), "供应商不能为空");
        	 Assert.isNotBlank(contractManage.getPurCompanyName(), "采购方不能为空");
        	 Assert.isNotBlank(contractManage.getContractNo(), "合同编号不能为空");

        	contractManage.setIsEnable(1);
        	contractManage.setCreateUserTime(new Date());
        	contractManage.setUpdateUserTime(new Date());
        	User loginUser = SpringSecurityUtils.getLoginUser();
            String username = loginUser.getUsername();
            contractManage.setCreateUserName(username);
            contractManage.setIssend(0);
            contractManage.setContractStatus(ContractStatus.CREATE.getCode());
            this.contractManageService.addObj(contractManage);
            return ResponseResult.success();
        }
        

    @ApiOperation(httpMethod="POST", value="编辑T_CONTRACT_MANAGE")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ContractManage contractManage) {
        Assert.isNotBlank(contractManage.getId(), "id 为空，保存失败");
        User loginUser = SpringSecurityUtils.getLoginUser();
        String username = loginUser.getUsername();
        contractManage.setUpdateUserName(username);
        contractManage.setUpdateUserTime(new Date());
        this.contractManageService.modifyObj(contractManage);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="逻辑删除合同单据")
    @RequestMapping("service/deleteByEnable")
    @ResponseBody
    public ResponseResult<String> deleteByEnable(@RequestParam(required=true) String id) {
    	 Assert.isNotBlank(id, "请选择一条记录");
    	 this.contractManageService.modifyById(id);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="批量逻辑删除合同单据")
    @RequestMapping("service/deleteByEnables")
    @ResponseBody
    public ResponseResult<String> deleteByEnables(@RequestBody(required=true) List<String> ids) {
    	if (ids == null || ids.isEmpty()) {
			throw new CommonException("删除失败,ids不能为空");
		}
    	for(String id : ids) {
			this.contractManageService.modifyById(id);
		}
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod="POST", value="删除T_CONTRACT_MANAGE")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        ContractManage contractManage = this.contractManageService.queryObjById(id);
        if (contractManage.getContractStatus()!=1) {
   			throw new CommonException("只有在新建的数据才可以删除");

		}
        this.contractManageService.deleteObjById(id);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod = "POST", value = "批量删除")
	@RequestMapping("service/deleteByIds")
	@ResponseBody
	public ResponseResult<String> deleteById(@RequestBody List<String> ids) {
		if (ids == null || ids.isEmpty()) {
			throw new CommonException("删除失败,ids不能为空");
		}
		for(String id : ids) {
			this.contractManageService.deleteObjById(id);
		}
		return ResponseResult.success();
	}

    @ApiOperation(httpMethod="POST", value="查询T_CONTRACT_MANAGE")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 ContractManage", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<ContractManage>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        ContractManageExample example = new ContractManageExample();
        example.setPageView(new PageView<ContractManage>(pageNo, pageSize));
        
        ContractManageExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如IS_ENABLE=1
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        //UpdateUserTime
        example.setOrderByClause(" UPDATE_USER_TIME DESC");
        PageView<ContractManage> pageData = this.contractManageService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    
    @ApiOperation(httpMethod="POST", value="根据主键id查询详情单个")
    @RequestMapping("service/queryById")
    @ResponseBody
    public ResponseResult<ContractManage> queryTemplateById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "查询id不能为空");
        ContractManage contractManage =  this.contractManageService.queryObjById(id);
        return ResponseResult.success(contractManage);
       
    }
    
    @ApiOperation(httpMethod = "POST", value = "上传附件")
   	@RequestMapping("service/attachment")
   	@ResponseBody
   	public ResponseResult<String> attachment( @RequestBody ContractManage contractManage) {
   		
   		if (StringUtils.isBlank(contractManage.getId())) {
   			throw new CommonException("id 为空，保存失败");
   		}
   		this.contractManageService.addAttachment(contractManage);
   		return ResponseResult.success();
   	}
    
    @ApiOperation(httpMethod = "POST", value = "合同作废")
   	@RequestMapping("service/discarded")
   	@ResponseBody
   	public ResponseResult<String> Discarded( @RequestBody ContractManage contractManage) {
   		
   		if (StringUtils.isBlank(contractManage.getId())) {
   			throw new CommonException("id 为空，保存失败");
   		}
   		if (contractManage.getContractStatus()==5) {
   			throw new CommonException("正在审核中的合同不能作废");
		}
   		if (contractManage.getContractStatus()==6) {
   			throw new CommonException("审核通过的合同不能作废");
		}
   		if (contractManage.getContractStatus()==8) {
   			throw new CommonException("已经签署的合同不能作废");
		}
   		if (contractManage.getContractStatus()==10) {
   			throw new CommonException("归档的合同不能作废");
		}
   		contractManage.setUpdateUserTime(new Date());
   		contractManage.setContractStatus(ContractStatus.INVALID.getCode());
   		contractManage.setIssend(0);
   		this.contractManageService.modifyObj(contractManage);
   		return ResponseResult.success();
   	}
    
    @ApiOperation(httpMethod = "POST", value = "发送给供应商，待供应商确认")
   	@RequestMapping("service/supconfirm")
   	@ResponseBody
   	public ResponseResult<String> ToSupConfirm( @RequestBody ContractManage contractManage) {
   		
   		if (StringUtils.isBlank(contractManage.getId())) {
   			throw new CommonException("id 为空，保存失败");
   		}
   		if(contractManage.getContractStatus() !=1){
			throw new CommonException("只有新建状态才可以");
   		}
   		contractManage.setUpdateUserTime(new Date());
   		contractManage.setContractStatus(ContractStatus.TO_SUP_CONFIRME.getCode());
   		//设置发送状态,供应商能够看到
   		contractManage.setIssend(1);
   		this.contractManageService.modifyObj(contractManage);
   		return ResponseResult.success();
   	}
    
    	@ApiOperation(httpMethod = "POST", value = "送审合同单据")
		@RequestMapping("service/approve")
		@ResponseBody
		public ResponseResult<String> approve(@RequestBody List<String> ids) {
    		if (ids == null || ids.isEmpty()) {
    			throw new CommonException("送审失败,ids不能为空");
    		}
			this.contractManageService.approve(ids);
			return ResponseResult.success();
		}
    	
    	
    	@ApiOperation(httpMethod = "POST", value = "签署合同")
		@RequestMapping("service/sign")
		@ResponseBody
		public ResponseResult<String> Sign(@RequestBody  ContractManage contractManage) {
    		if (StringUtils.isBlank(contractManage.getId())) {
       			throw new CommonException("id 为空，保存失败");
       		}if (contractManage.getContractStatus() != 6) {
       			throw new CommonException("只有审批通过才能签署合同");
			}
       		if (StringUtils.isEmpty(contractManage.getSupattachment())) {
       			throw new CommonException("供应商上传附件之后才能签署合同");
			} 
       		contractManage.setUpdateUserTime(new Date());
    		contractManage.setContractStatus(ContractStatus.SIGN.getCode());
    		this.contractManageService.modifyObj(contractManage);
			return ResponseResult.success();
		}
  
    	@ApiOperation(httpMethod = "POST", value = "pdf预览")
		@RequestMapping("service/previewPDF")
		@ResponseBody
		public ResponseResult<FileData> PreviewPDF(@RequestParam String id ) {
    		if (StringUtils.isBlank(id)) {
       			throw new CommonException("id 为空，保存失败");
       		}
    	//	FileData pdfFile = null; 
    		ContractManage contractManage = this.contractManageService.queryObjById(id);
    		String contractContent = contractManage.getContractContent();
             String companyId = ProjectUtils.getCompanyId();
             String projectId = ProjectUtils.getProjectId();
             //FileData pdfFile = ContractPrintUtils.generatePdf(contractContent, projectId, companyId);
            FileData pdfFile = ContractPrintUtils.generatePdf(contractManage);
	    		
    	/*	 try {
				InputStream is =new ByteArrayInputStream(contractContent.getBytes("UTF-8"));
				ByteArrayOutputStream baos = new ByteArrayOutputStream();  
				int i;  
				while ((i = is.read()) != -1) {  
				    baos.write(i);  
				}  
			} catch (Exception e) {
				e.printStackTrace();
       			throw new CommonException("打印失败");

			}*/
    		
    		
			return ResponseResult.success(pdfFile);
		}

    	
    	@ApiOperation(httpMethod = "POST", value = "归档")
		@RequestMapping("service/file")
		@ResponseBody
		public ResponseResult<String> File(@RequestBody  ContractManage contractManage) {
    		if (StringUtils.isBlank(contractManage.getId())) {
       			throw new CommonException("id 为空，保存失败");
       		}
    		if(contractManage.getContractStatus()!=8) {
       			throw new CommonException("只有签署的合同才能归档");
    		}
    		contractManage.setUpdateUserTime(new Date());
    		contractManage.setContractStatus(ContractStatus.FILE.getCode());
    		this.contractManageService.modifyObj(contractManage);
			return ResponseResult.success();
		}
    
}