package com.els.kangni.contract.manage.controller;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.kangni.contract.manage.emum.ContractStatus;
import com.els.kangni.contract.manage.entity.ContractManage;
import com.els.kangni.contract.manage.entity.ContractManageExample;
import com.els.kangni.contract.manage.service.ContractManageService;

@Api(value="T_CONTRACT_MANAGE")
@Controller
@RequestMapping("supContractManage")
public class SupContractManageController {
	 @Resource
	 protected ContractManageService contractManageService;
	 @ApiOperation(httpMethod="POST", value="查询T_CONTRACT_MANAGE")
	    @ApiImplicitParams({ 
			@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
			@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
			@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 ContractManage", paramType = "body", dataType = "QueryParamWapper" )  
		}) 
	    @RequestMapping("service/findByPage")
	    @ResponseBody
	    public ResponseResult<PageView<ContractManage>> findByPage( 
			@RequestParam(defaultValue="0") int pageNo,  
			@RequestParam(defaultValue="10") int pageSize, 
			@RequestBody(required=false) QueryParamWapper wapper) {
	        ContractManageExample example = new ContractManageExample();
	        example.setPageView(new PageView<ContractManage>(pageNo, pageSize));
	        
	        ContractManageExample.Criteria criteria = example.createCriteria();
	        //填写具体的查询条件，没有被删除，可以让供应商看的
	        criteria.andIsEnableEqualTo(Constant.YES_INT).andIssendEqualTo(1);
	        // 供应商只查询自己公司的记录
	        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
	        
	        if (wapper != null) {
	            CriteriaUtils.addExample(example, wapper);
	        }
	        //UpdateUserTime
	        example.setOrderByClause(" UPDATE_USER_TIME DESC");
	        PageView<ContractManage> pageData = this.contractManageService.queryObjByPage(example);
	        return ResponseResult.success(pageData);
	    }
	    
	    
	    @ApiOperation(httpMethod="POST", value="根据主键id查询详情单个")
	    @RequestMapping("service/queryById")
	    @ResponseBody
	    public ResponseResult<ContractManage> queryTemplateById(@RequestParam(required=true) String id) {
	        Assert.isNotBlank(id, "查询id不能为空");
	        ContractManage contractManage =  this.contractManageService.queryObjById(id);
	        return ResponseResult.success(contractManage);
	       
	    }
	    
	    @ApiOperation(httpMethod = "POST", value = "供应商确认")
	   	@RequestMapping("service/supconfirm")
	   	@ResponseBody
	   	public ResponseResult<String> ToSupConfirm( @RequestBody ContractManage contractManage) {
	   		
	   		if (StringUtils.isBlank(contractManage.getId())) {
	   			throw new CommonException("id 为空，保存失败");
	   		}
	   		if(contractManage.getContractStatus() !=2){
				throw new CommonException("只有待供应商确认状态才可以确认");
	   		}
	   		contractManage.setUpdateUserTime(new Date());
	   		contractManage.setContractStatus(ContractStatus.SUPPLIER_CONFIRMED.getCode());
	   		this.contractManageService.modifyObj(contractManage);
	   		return ResponseResult.success();
	   	}
	    
	    @ApiOperation(httpMethod = "POST", value = "供应商拒绝")
	   	@RequestMapping("service/suprefuse")
	   	@ResponseBody
	   	public ResponseResult<String> supRefused( @RequestBody ContractManage contractManage) {
	   		
	   		if (StringUtils.isBlank(contractManage.getId())) {
	   			throw new CommonException("id 为空，保存失败");
	   		}
	   		if(contractManage.getContractStatus() !=2){
				throw new CommonException("只有待供应商确认状态才可以拒绝");
	   		}
	   		contractManage.setUpdateUserTime(new Date());
	   		contractManage.setContractStatus(ContractStatus.SUPPLIER_REFUSED.getCode());
	   		this.contractManageService.modifyObj(contractManage);
	   		return ResponseResult.success();
	   	}
	    
	    
	    @ApiOperation(httpMethod = "POST", value = "供应商上传附件")
	   	@RequestMapping("service/attachment")
	   	@ResponseBody
	   	public ResponseResult<String> attachment( @RequestBody ContractManage contractManage) {
	   		
	   		if (StringUtils.isBlank(contractManage.getId())) {
	   			throw new CommonException("id 为空，保存失败");
	   		}
	   		this.contractManageService.addAttachment(contractManage);
	   		return ResponseResult.success();
	   	}
	    
	    
	
	    
}
