package com.els.kangni.contract.manage.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;

import com.els.base.file.utils.UploadSupportJsonDeserializer;
import com.els.base.file.utils.UploadSupportJsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
@ApiModel(value="合同")
public class ContractManage implements Serializable {
    @ApiModelProperty("主键ID")
    private String id;

    @ApiModelProperty("合同编号")
    private String contractNo;

    @ApiModelProperty("合同描述")
    private String contractDescription;

    @ApiModelProperty("合同类型")
    private String contractType;

    @ApiModelProperty("合同名称")
    private String contractName;

    @ApiModelProperty("版本")
    private String version;

    @ApiModelProperty("模板编号")
    private String templateNo;

    @ApiModelProperty("模板类型")
    private String templateType;

    @ApiModelProperty("模板版本")
    private String templateVersion;

    @ApiModelProperty("是否发送给供应方（1=发送，供应商能查看到，0=未发送，供应商不能查看）")
    private Integer issend;

    @ApiModelProperty("送审结果")
    private String approveResult;

    @ApiModelProperty("合同新建=1，供应商待确认=2，供应商已确认=3，供应商拒绝=4，审批中=5，审批通过=6，审批拒绝=7，签署合同=8，作废=9，归档=10")
    private Integer contractStatus;

    @ApiModelProperty("签订日期")
    private Date signDate;

    @ApiModelProperty("生效日期")
    private Date effectiveDate;

    @ApiModelProperty("到期日期")
    private Date expirationDate;

    @ApiModelProperty("签订地点")
    private String signPlace;

    @ApiModelProperty("采购方ID")
    private String purCompanyId;

    @ApiModelProperty("采购商公司SRM编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购商公司SAP编码")
    private String purCompanySapCod;

    @ApiModelProperty("采购组织")
    private String purCompanyName;

    @ApiModelProperty("采购组")
    private String purGroup;

    @ApiModelProperty("采购负责人")
    private String purHead;

    @ApiModelProperty("采购方备注")
    private String purMark;

    @ApiModelProperty("业务组")
    private String businessGroup;

    @ApiModelProperty("提醒天数")
    private Integer remindDays;

    @ApiModelProperty("供应方ID")
    private String supCompanyId;

    @ApiModelProperty("供应方name")
    private String supCompanyName;

    @ApiModelProperty("供应商公司SRM编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商公司SAP编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应方负责人")
    private String supHead;

    @ApiModelProperty("供应方备注")
    private String supMark;

    @ApiModelProperty("类型（采购方=1，供应方=0）")
    private Integer type;

    @ApiModelProperty("创建人")
    private String createUserName;

    @ApiModelProperty("创建时间")
    private Date createUserTime;

    @ApiModelProperty("更新人")
    private String updateUserName;

    @ApiModelProperty("更新时间")
    private Date updateUserTime;

    @ApiModelProperty("软删除（可用=1，不可用=0）")
    private Integer isEnable;
  
    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("采购方文件上传")
    private String attachment;

    @JsonSerialize(using=UploadSupportJsonSerializer.class)
    @JsonDeserialize(using=UploadSupportJsonDeserializer.class)
    @ApiModelProperty("供应方文件上传")
    private String supattachment;

    @ApiModelProperty("文件类型")
    private String fileType;

    @ApiModelProperty("合同正文")
    private String contractContent;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getContractNo() {
        return contractNo;
    }

    public void setContractNo(String contractNo) {
        this.contractNo = contractNo == null ? null : contractNo.trim();
    }

    public String getContractDescription() {
        return contractDescription;
    }

    public void setContractDescription(String contractDescription) {
        this.contractDescription = contractDescription == null ? null : contractDescription.trim();
    }

    public String getContractType() {
        return contractType;
    }

    public void setContractType(String contractType) {
        this.contractType = contractType == null ? null : contractType.trim();
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName == null ? null : contractName.trim();
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version == null ? null : version.trim();
    }

    public String getTemplateNo() {
        return templateNo;
    }

    public void setTemplateNo(String templateNo) {
        this.templateNo = templateNo == null ? null : templateNo.trim();
    }

    public String getTemplateType() {
        return templateType;
    }

    public void setTemplateType(String templateType) {
        this.templateType = templateType == null ? null : templateType.trim();
    }

    public String getTemplateVersion() {
        return templateVersion;
    }

    public void setTemplateVersion(String templateVersion) {
        this.templateVersion = templateVersion == null ? null : templateVersion.trim();
    }

    public Integer getIssend() {
        return issend;
    }

    public void setIssend(Integer issend) {
        this.issend = issend;
    }

    public String getApproveResult() {
        return approveResult;
    }

    public void setApproveResult(String approveResult) {
        this.approveResult = approveResult == null ? null : approveResult.trim();
    }

    public Integer getContractStatus() {
        return contractStatus;
    }

    public void setContractStatus(Integer contractStatus) {
        this.contractStatus = contractStatus;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Date getExpirationDate() {
        return expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace == null ? null : signPlace.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCod() {
        return purCompanySapCod;
    }

    public void setPurCompanySapCod(String purCompanySapCod) {
        this.purCompanySapCod = purCompanySapCod == null ? null : purCompanySapCod.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurGroup() {
        return purGroup;
    }

    public void setPurGroup(String purGroup) {
        this.purGroup = purGroup == null ? null : purGroup.trim();
    }

    public String getPurHead() {
        return purHead;
    }

    public void setPurHead(String purHead) {
        this.purHead = purHead == null ? null : purHead.trim();
    }

    public String getPurMark() {
        return purMark;
    }

    public void setPurMark(String purMark) {
        this.purMark = purMark == null ? null : purMark.trim();
    }

    public String getBusinessGroup() {
        return businessGroup;
    }

    public void setBusinessGroup(String businessGroup) {
        this.businessGroup = businessGroup == null ? null : businessGroup.trim();
    }

    public Integer getRemindDays() {
        return remindDays;
    }

    public void setRemindDays(Integer remindDays) {
        this.remindDays = remindDays;
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupHead() {
        return supHead;
    }

    public void setSupHead(String supHead) {
        this.supHead = supHead == null ? null : supHead.trim();
    }

    public String getSupMark() {
        return supMark;
    }

    public void setSupMark(String supMark) {
        this.supMark = supMark == null ? null : supMark.trim();
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName == null ? null : createUserName.trim();
    }

    public Date getCreateUserTime() {
        return createUserTime;
    }

    public void setCreateUserTime(Date createUserTime) {
        this.createUserTime = createUserTime;
    }

    public String getUpdateUserName() {
        return updateUserName;
    }

    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName == null ? null : updateUserName.trim();
    }

    public Date getUpdateUserTime() {
        return updateUserTime;
    }

    public void setUpdateUserTime(Date updateUserTime) {
        this.updateUserTime = updateUserTime;
    }

    public String getAttachment() {
        return attachment;
    }

    public void setAttachment(String attachment) {
        this.attachment = attachment == null ? null : attachment.trim();
    }

    public String getSupattachment() {
        return supattachment;
    }

    public void setSupattachment(String supattachment) {
        this.supattachment = supattachment == null ? null : supattachment.trim();
    }

    public String getFileType() {
        return fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType == null ? null : fileType.trim();
    }

    public Integer getIsEnable() {
        return isEnable;
    }

    public void setIsEnable(Integer isEnable) {
        this.isEnable = isEnable;
    }

    public String getContractContent() {
        return contractContent;
    }

    public void setContractContent(String contractContent) {
        this.contractContent = contractContent == null ? null : contractContent.trim();
    }
}