package com.els.kangni.contract.manage.service.impl;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import com.els.kangni.contract.manage.dao.ContractManageMapper;
import com.els.kangni.contract.manage.emum.ContractStatus;
import com.els.kangni.contract.manage.entity.ContractManage;
import com.els.kangni.contract.manage.entity.ContractManageExample;
import com.els.kangni.contract.manage.service.ContractManageService;

@Service("defaultContractManageService")
public class ContractManageServiceImpl implements ContractManageService ,ITaskListener{
    @Resource
    protected ContractManageMapper contractManageMapper;
    
    @Resource
	protected WorkFlowService workFlowService;
    
    @CacheEvict(value = { "contractManage" }, allEntries = true)
	@Override
	public void listen(TaskOperateEvent event) {

		if(event==null){
			return;
		}

		//获取业务ID
		String businessId = event.getBusinessId();
		if(StringUtils.isBlank(businessId)){
			return;
		}
		ContractManage contractManage = this.contractManageMapper.selectByPrimaryKey(businessId);
		String assignee = StringUtils.defaultIfBlank(event.getAssignee(),"");
		String fullMessage = StringUtils.defaultIfBlank(event.getApproveDesc(),"");
		String result="审批人："+assignee+"，审批意见："+fullMessage+" ; ";

		//1、审批流完成而且通过
		if (event.isFinished() && event.isPass()) {
			//做修改业务操作
			contractManage.setContractStatus(ContractStatus.AUDITED.getCode());
			contractManage.setApproveResult(result);
			contractManage.setUpdateUserTime(new Date());
			this.contractManageMapper.updateByPrimaryKeySelective(contractManage);
			//2、审批流完成但被驳回
		}else if(event.isFinished() && !event.isPass()){
			contractManage.setUpdateUserTime(new Date());
			contractManage.setContractStatus(ContractStatus.APPROVAL_REFUSE.getCode());
			this.contractManageMapper.updateByPrimaryKeySelective(contractManage);
		}

	}

    @CacheEvict(value={"contractManage"}, allEntries=true)
    @Override
    public void addObj(ContractManage t) {
        if (StringUtils.isBlank(t.getTemplateNo())) {
            throw new NullPointerException("编号不能为空");
        } 
        this.contractManageMapper.insertSelective(t);
    }

    @CacheEvict(value={"contractManage"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.contractManageMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"contractManage"}, allEntries=true)
    @Override
    public void modifyObj(ContractManage t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.contractManageMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="contractManage", keyGenerator="redisKeyGenerator")
    @Override
    public ContractManage queryObjById(String id) {
        return this.contractManageMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="contractManage", keyGenerator="redisKeyGenerator")
    @Override
    public List<ContractManage> queryAllObjByExample(ContractManageExample example) {
        return this.contractManageMapper.selectByExample(example);
    }

    @Cacheable(value="contractManage", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<ContractManage> queryObjByPage(ContractManageExample example) {
        PageView<ContractManage> pageView = example.getPageView();
        pageView.setQueryResult(this.contractManageMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value="contractManage", allEntries = true)
    @Override
	public void modifyById(String id) {
    	this.contractManageMapper.modifyById(id);
	}
	
	@CacheEvict(value = { "contractManage" }, allEntries = true)
	@Override
	public void addAttachment(ContractManage contractManage) {
		
		String id = contractManage.getId();
		if (org.springframework.util.StringUtils.isEmpty(id)) {
			throw new CommonException("合同ID不能为空");
		}
		
		this.contractManageMapper.updateByPrimaryKeySelective(contractManage);
	}

	@CacheEvict(value = { "contractManage" }, allEntries = true)
	@Override
	public void approve(List<String> ids) {
		Assert.isNotEmpty(ids,"ID不能为空，不能提交审核！");

		ContractManageExample contractManageExample =  new ContractManageExample();
		contractManageExample.createCriteria().andIdIn(ids);

		List<ContractManage> contractManages = this.contractManageMapper.selectByExample(contractManageExample);
		if(CollectionUtils.isEmpty(contractManages)){
			return;
		}

		for (ContractManage contractManage : contractManages) {
			ProcessStartVO vo= ProcessStartVO.newInstance("ht", contractManage.getContractNo(), contractManage.getId(),"contractBillManager?id="+contractManage.getId());
			vo.setListenerClass(this.getClass());
			ProcessInstance startProcess=this.workFlowService.startProcess(vo);
			if(startProcess!=null) {
				contractManage.setUpdateUserTime(new Date());
				contractManage.setContractStatus(ContractStatus.TOAUDIT.getCode());
				this.contractManageMapper.updateByPrimaryKeySelective(contractManage);
			}
		}
	}

	@Override
	public int countByExample(ContractManageExample example) {
		return contractManageMapper.countByExample(example);
	}

	@CacheEvict(value="contractManage", allEntries = true)
	@Transactional
	@Override
	public void addAll(List<ContractManage> arg0) {
		if (CollectionUtils.isEmpty(arg0)) {
			return;
		}
		for (ContractManage record : arg0) {
			this.contractManageMapper.insertSelective(record);
		}
	}

	@CacheEvict(value="contractManage", allEntries = true)
	@Override
	public void deleteByExample(ContractManageExample arg0) {
		Assert.isNotEmpty(arg0.getOredCriteria(), "删除的条件不能为空");
		this.contractManageMapper.deleteByExample(arg0);
	}


}