package com.els.kangni.contract.manage.utils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.utils.template.BeetlTemplateUtils;
import com.els.kangni.contract.manage.entity.ContractManage;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class ContractPrintUtils {

    private static Logger logger = LoggerFactory.getLogger(ContractPrintUtils.class);

    public static FileData generatePdf(String contractContent, String projectId, String companyId) {

        String filename = null;  //pdf文件名
        FileData pdfFile = null;
        filename = "合同正文" + DateFormatUtils.format(new Date(), "yyyy-MM-dd-HH-mm");
        try {
            pdfFile = createEmptyPDF(projectId, companyId, filename);

            HtmlToPdfUtils.generatePdf(contractContent, pdfFile.toFile(), HtmlToPdfUtils.PAGE_SIZE_A4, true, filename);
        } catch (IOException | InterruptedException e) {
            e.printStackTrace();
            throw new CommonException("导出PDF异常");
        }
        return pdfFile;
    }

    public static FileData generatePdf(ContractManage contractManage) {

        // 设置参数
        Map<String, Object> params = new HashMap<>();
        params.put("ContractManage", contractManage);
        //params.put("fontPath", ContractPrintUtils.class.getClassLoader().getResource("").toString() + "fonts/nsimsum.ttf");

        String filename = null;  //pdf文件名
        FileData pdfFile = null; //pdf文件
        String html = null;      //pdf生成需要的html

        // 选择html模板
        html = BeetlTemplateUtils.renderFromFile("ContractManagerContent.html", params);
        logger.info("PDF---HTML内容"+html);
        logger.info(html);
        filename = "合同正文" + DateFormatUtils.format(new Date(), "yyyy-MM-dd-HH-mm");
        try {
            logger.info("PDF---HTML内容"+html);
            pdfFile = createEmptyPDF(CompanyUtils.currentCompany().getProjectId(), CompanyUtils.currentCompanyId(), filename);

            HtmlToPdfUtils.generatePdf(html, pdfFile.toFile(), HtmlToPdfUtils.PAGE_SIZE_A4, true, filename);
        } catch (IOException | InterruptedException e) {
            e.printStackTrace();
            throw new CommonException("导出PDF异常");
        }
        return pdfFile;
    }

    public static FileData createEmptyPDF(String projectId, String companyId, String filename) throws UnsupportedEncodingException, IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);

        pdfFile.setFileName(filename + ".pdf");
        pdfFile.setFileSuffix("pdf");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addMinutes(new Date(), 30));
        FileManagerFactory.getFileManager().createEmptyFile(pdfFile);
        return pdfFile;
    }
}