package com.els.kangni.contract.template.service.impl;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.base.workflow.common.service.WorkFlowService;
import com.els.kangni.contract.template.dao.ContractTemplateMapper;
import com.els.kangni.contract.template.emum.AuditStatus;
import com.els.kangni.contract.template.entity.ContractTemplate;
import com.els.kangni.contract.template.entity.ContractTemplateExample;
import com.els.kangni.contract.template.service.ContractTemplateService;

@Service("defaultContractTemplateService")
public class ContractTemplateServiceImpl implements ContractTemplateService, ITaskListener{
    @Resource
    protected ContractTemplateMapper contractTemplateMapper;
    
    @Resource
	protected WorkFlowService workFlowService;
    
    @Transactional
    @CacheEvict(value = { "contractTemplate" }, allEntries = true)
	@Override
	public void listen(TaskOperateEvent event) {

		if(event==null){
			return;
		}

		//获取业务ID
		String businessId = event.getBusinessId();
		if(StringUtils.isBlank(businessId)){
			return;
		}
		ContractTemplate contractTemplate = this.contractTemplateMapper.selectByPrimaryKey(businessId);
		String assignee = StringUtils.defaultIfBlank(event.getAssignee(),"");
		String fullMessage = StringUtils.defaultIfBlank(event.getApproveDesc(),"");
		String result="审批人："+assignee+"，审批意见："+fullMessage+" ; ";

		//1、审批流完成而且通过
		if (event.isFinished() && event.isPass()) {
			//做修改业务操作
			contractTemplate.setAuditStatus(AuditStatus.AUDITED.getCode());
	        contractTemplate.setUpdateUserTime(new Date());
			contractTemplate.setApproveResult(result);
			this.contractTemplateMapper.updateByPrimaryKeySelective(contractTemplate);
		
			//2、审批流完成但未通过
		}else if(event.isFinished() && !event.isPass()){
	        contractTemplate.setUpdateUserTime(new Date());
			contractTemplate.setAuditStatus(AuditStatus.REFUSED.getCode());
			this.contractTemplateMapper.updateByPrimaryKeySelective(contractTemplate);

		}

	}

    @CacheEvict(value={"contractTemplate"}, allEntries=true)
    @Override
    public void addObj(ContractTemplate t) {
        this.contractTemplateMapper.insertSelective(t);
    }

    @CacheEvict(value={"contractTemplate"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.contractTemplateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"contractTemplate"}, allEntries=true)
    @Override
    public void modifyObj(ContractTemplate t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.contractTemplateMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="contractTemplate", keyGenerator="redisKeyGenerator")
    @Override
    public ContractTemplate queryObjById(String id) {
        return this.contractTemplateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="contractTemplate", keyGenerator="redisKeyGenerator")
    @Override
    public List<ContractTemplate> queryAllObjByExample(ContractTemplateExample example) {
        return this.contractTemplateMapper.selectByExample(example);
    }

    @Cacheable(value="contractTemplate", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<ContractTemplate> queryObjByPage(ContractTemplateExample example) {
        PageView<ContractTemplate> pageView = example.getPageView();
        pageView.setQueryResult(this.contractTemplateMapper.selectByExampleByPage(example));
        return pageView;
    }
    

    
    
    @Transactional
    @CacheEvict(value="contractTemplate", allEntries = true)
	@Override
	public void approve(List<String> ids) {
    	Assert.isNotEmpty(ids,"ID不能为空，不能提交审核！");
			ContractTemplateExample example = new ContractTemplateExample();
			example.createCriteria().andIdIn(ids).andAuditStatusEqualTo(AuditStatus.UNAUDITED.getCode());
			int count = contractTemplateMapper.countByExample(example);
			if (count != ids.size()) {
				throw new CommonException("只有处于新建的记录才能提交审批，请检查");
			}
			
			List<ContractTemplate> contractTemplates = this.contractTemplateMapper.selectByExample(example);
			if(CollectionUtils.isEmpty(contractTemplates)){
				return;
			}
			for (ContractTemplate contractTemplate : contractTemplates) {
				ProcessStartVO vo= ProcessStartVO.newInstance("ct", contractTemplate.getTemplateNo(), contractTemplate.getId(),"contractTemplateManager?id="+contractTemplate.getId());
				vo.setListenerClass(this.getClass());
				ProcessInstance startProcess=this.workFlowService.startProcess(vo);

				if(startProcess!=null) {
					//将状态改成审批中
			        contractTemplate.setUpdateUserTime(new Date());
					contractTemplate.setAuditStatus((AuditStatus.TOAUDIT.getCode()));
					contractTemplateMapper.updateByPrimaryKeySelective(contractTemplate);
				}
				
			}
		
    }
    
    @Transactional
    @CacheEvict(value="contractTemplate", allEntries = true)
	@Override
	public void modifyById(String id) {
		this.contractTemplateMapper.modifyById(id);
	}

	@CacheEvict(value = { "contractTemplate" }, allEntries = true)
	@Override
	public void addAttachment(ContractTemplate contractTemplate) {
		
		String id = contractTemplate.getId();
		
		if (org.springframework.util.StringUtils.isEmpty(id)) {
			throw new CommonException("合同模板ID不能为空");
		}
		
		contractTemplateMapper.updateByPrimaryKeySelective(contractTemplate);
	}

	@CacheEvict(value="contractTemplate", allEntries = true)
	@Transactional
	@Override
	public void addAll(List<ContractTemplate> arg0) {
		if (CollectionUtils.isEmpty(arg0)) {
			return;
		}
		for (ContractTemplate record : arg0) {
			this.contractTemplateMapper.insertSelective(record);
		}
	}

	@CacheEvict(value="contractTemplate", allEntries = true)
	@Override
	public void deleteByExample(ContractTemplateExample arg0) {
		Assert.isNotEmpty(arg0.getOredCriteria(), "删除的条件不能为空");
		this.contractTemplateMapper.deleteByExample(arg0);
	}

}
    
    
  
