package com.els.kangni.contract.template.web.controller;
import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.kangni.contract.template.emum.AuditStatus;
import com.els.kangni.contract.template.emum.TemplateStatus;
import com.els.kangni.contract.template.entity.ContractTemplate;
import com.els.kangni.contract.template.entity.ContractTemplateExample;
import com.els.kangni.contract.template.service.ContractTemplateService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;



@Api(value=" 合同模板 ")
@Controller
@RequestMapping("contractTemplate")
public class ContractTemplateController {
	
    @Resource
    protected ContractTemplateService contractTemplateService;
    

    
    @ApiOperation(httpMethod="POST", value="创建合同模板")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody ContractTemplate contractTemplate) {
    	 Assert.isNotBlank(contractTemplate.getTemplateNo(), "模板编号不能为空");
    	 Assert.isNotBlank(contractTemplate.getTemplateType(), "模板类型不能为空");
    	 Assert.isNotBlank(contractTemplate.getVersion(), "模板版本不能为空");
    	contractTemplate.setIsEnable(1);
    	contractTemplate.setCreateTime(new Date());
    	contractTemplate.setUpdateUserTime(new Date());
    	contractTemplate.setAuditStatus(AuditStatus.UNAUDITED.getCode());
        this.contractTemplateService.addObj(contractTemplate);
        return ResponseResult.success();
    }
    
   

    @ApiOperation(httpMethod="POST", value="编辑合同模板")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody ContractTemplate contractTemplate) {
        Assert.isNotBlank(contractTemplate.getId(), "id 为空，保存失败");
        User loginUser = SpringSecurityUtils.getLoginUser();
        String username = loginUser.getUsername();
        contractTemplate.setUpdateUserName(username);
        contractTemplate.setUpdateUserTime(new Date());
        this.contractTemplateService.modifyObj(contractTemplate);
        return ResponseResult.success();
    }
    
    
    @ApiOperation(httpMethod="POST", value="逻辑删除合同模板")
    @RequestMapping("service/deleteByEnable")
    @ResponseBody
    public ResponseResult<String> deleteByEnable(@RequestParam(required=true) String id) {
    	 Assert.isNotBlank(id, "请选择一条记录");
    	 this.contractTemplateService.modifyById(id);
        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod="POST", value="批量逻辑删除合同模板")
    @RequestMapping("service/deleteByEnables")
    @ResponseBody
    public ResponseResult<String> deleteByEnables(@RequestBody(required=true) List<String> ids) {
    	if (ids == null || ids.isEmpty()) {
			throw new CommonException("删除失败,ids不能为空");
		}
    	for(String id : ids) {
			this.contractTemplateService.modifyById(id);
		}
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除合同模板")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        ContractTemplate template = this.contractTemplateService.queryObjById(id);
        if (template.getAuditStatus()!=1) {
        	throw new CommonException("只有新建的数据才能删除");
		}
        this.contractTemplateService.deleteObjById(id);
        return ResponseResult.success();
    }
    
	@ApiOperation(httpMethod = "POST", value = "批量删除")
	@RequestMapping("service/deleteByIds")
	@ResponseBody
	public ResponseResult<String> deleteById(@RequestBody List<String> ids) {
		if (ids == null || ids.isEmpty()) {
			throw new CommonException("删除失败,ids不能为空");
		}
		for(String id : ids) {
			this.contractTemplateService.deleteObjById(id);
		}
		return ResponseResult.success();
	}

    @ApiOperation(httpMethod="POST", value="查询合同模板")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 ContractTemplate", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<ContractTemplate>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        ContractTemplateExample example = new ContractTemplateExample();
        example.setPageView(new PageView<ContractTemplate>(pageNo, pageSize));
        ContractTemplateExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如IS_ENABLE=1
       criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        //UpdateUserTime
        example.setOrderByClause(" UPDATE_USER_TIME DESC");
        PageView<ContractTemplate> pageData = this.contractTemplateService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    
    @ApiOperation(httpMethod="POST", value="查询审核通过的合同模板")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 ContractTemplate", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPass")
    @ResponseBody
    public ResponseResult<PageView<ContractTemplate>> findByP( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        ContractTemplateExample example = new ContractTemplateExample();
        example.setPageView(new PageView<ContractTemplate>(pageNo, pageSize));
        ContractTemplateExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如IS_ENABLE=1
       criteria.andIsEnableEqualTo(Constant.YES_INT);
       criteria.andAuditStatusEqualTo(3);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        //UpdateUserTime
        example.setOrderByClause(" UPDATE_USER_TIME DESC");
        PageView<ContractTemplate> pageData = this.contractTemplateService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="根据主键id查询详情单个")
    @RequestMapping("service/queryById")
    @ResponseBody
    public ResponseResult<ContractTemplate> queryTemplateById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "查询id不能为空");
        ContractTemplate contractTemplate =  this.contractTemplateService.queryObjById(id);
        return ResponseResult.success(contractTemplate);
       
    }
    
    
    @ApiOperation(httpMethod = "POST", value = "上传附件")
	@RequestMapping("service/attachment")
	@ResponseBody
	public ResponseResult<String> attachment( @RequestBody ContractTemplate contractTemplate) {
		
		if (StringUtils.isBlank(contractTemplate.getId())) {
			throw new CommonException("id 为空，保存失败");
		}
		this.contractTemplateService.addAttachment(contractTemplate);
		return ResponseResult.success();
	}
    
    
    
    @ApiOperation(httpMethod = "POST", value = "送审模板")
	@RequestMapping("service/approve")
	@ResponseBody
	public ResponseResult<String> approve(@RequestBody List<String> ids) {
		if (ids == null || ids.isEmpty()) {
			throw new CommonException("送审失败,ids不能为空");
		}
		this.contractTemplateService.approve(ids);
		return ResponseResult.success();
	}
    
 
}