/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.i18n.config;

import com.els.base.core.config.I18nIsEnableConfiguration;
import com.els.base.i18n.web.MessageResource;
import com.els.base.i18n.web.UrlParameterLocaleResolver;
import javax.annotation.PostConstruct;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;

@Configuration
public class I18nConfiguration
implements WebMvcConfigurer {
    @PostConstruct
    protected void afterProperties() {
        I18nIsEnableConfiguration.setIsEnable((boolean)true);
    }

    @Bean(value={"messageSource"})
    protected MessageResource getMessageResource() {
        return new MessageResource();
    }

    @Bean(value={"localeResolver"})
    protected UrlParameterLocaleResolver getUrlParameterLocaleResolver() {
        UrlParameterLocaleResolver localeResolver = new UrlParameterLocaleResolver();
        localeResolver.setCookiePath("/");
        return localeResolver;
    }

    @Bean(value={"localeChangeInterceptor"})
    public HandlerInterceptor getLocaleChangeInterceptor() {
        LocaleChangeInterceptor interceptor = new LocaleChangeInterceptor();
        interceptor.setParamName("local_i18n");
        return interceptor;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor(this.getLocaleChangeInterceptor()).addPathPatterns(new String[]{"/**"});
    }
}

