/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.im;

import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.utils.dictonary.DicUtils;
import com.els.base.msg.IMessage;
import com.els.base.msg.IMessageCommand;
import com.els.base.msg.im.entity.ImTemplate;
import com.els.base.msg.im.service.ImTemplateService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.template.BeetlTemplateUtils;
import com.qqt.message.client.MessageClient;
import com.qqt.message.client.MessageClientFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImMessageCommand
implements IMessageCommand {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ImMessageCommand.class);
    public static final String TYPE_SYSTEM = "system";
    public static final String TYPE_PERSONAL = "personal";
    private static MessageClient client;

    private static ImTemplateService getImTemplateService() {
        return (ImTemplateService)SpringContextHolder.getOneBean(ImTemplateService.class);
    }

    public ImMessageCommand() {
        try {
            if (client == null) {
                client = MessageClientFactory.createPushMessageInstance();
            }
        }
        catch (Exception e) {
            logger.error("\u6d88\u606f\u5de5\u5177\u7c7b\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    @Override
    public void sendMsg(IMessage<?> message) throws Exception {
        String pageParam;
        Set<String> accounts = this.getAccount(message.getReceiverIdList());
        String type = this.getImMsgType(message);
        String companyCode = message.getCompanyCode();
        String businessTypeCode = message.getBusinessTypeCode();
        if (CollectionUtils.isEmpty(accounts)) {
            logger.warn("\u63a5\u6536\u4eba\u7684\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f");
            return;
        }
        ImTemplate imTemplate = ImMessageCommand.getImTemplateService().queryImTemplateByBusinessType(businessTypeCode);
        if (imTemplate == null) {
            logger.warn("im\u6d88\u606f\u6a21\u677f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f");
            return;
        }
        String imContent = imTemplate.getTemplateContent();
        try {
            imContent = BeetlTemplateUtils.renderFromString((String)imContent, (String)"message", message);
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528\u6a21\u677f\u751f\u6210\u6d88\u606f\u5185\u5bb9\u5931\u8d25", (Throwable)e);
        }
        HashMap<String, String> extras = new HashMap<String, String>();
        extras.put("level", message.getMsgLevel().getLevel());
        String page = imTemplate.getPage();
        if (StringUtils.isNotBlank((String)page)) {
            extras.put("page", BeetlTemplateUtils.renderFromString((String)page, (String)"message", message));
        }
        if (StringUtils.isNotBlank((String)(pageParam = imTemplate.getPageParam()))) {
            extras.put("orderId", BeetlTemplateUtils.renderFromString((String)pageParam, (String)"message", message));
        }
        extras.put("from", imTemplate.getMessageFrom());
        String fromCode = imTemplate.getFromCode();
        if (StringUtils.isNotBlank((String)fromCode)) {
            extras.put("hisCode", BeetlTemplateUtils.renderFromString((String)fromCode, (String)"message", message));
        }
        logger.info("imContent====" + imContent);
        logger.info("page====" + (String)extras.get("page"));
        logger.info("orderId====" + (String)extras.get("orderId"));
        logger.info("from====" + (String)extras.get("from"));
        logger.info("hisCode====" + (String)extras.get("hisCode"));
        DicGroupItem item = DicUtils.getDicGroupItemByCode((String)"business_type", (String)message.getBusinessTypeCode());
        client.pushMessage(item.getName(), imContent, type, accounts, extras, companyCode, message.getSenderId());
    }

    private String getImMsgType(IMessage<?> message) {
        return TYPE_SYSTEM;
    }

    private Set<String> getAccount(List<String> receiverIdList) {
        HashSet<String> accounts = new HashSet<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(receiverIdList) && i < receiverIdList.size(); ++i) {
            accounts.add(receiverIdList.get(i));
        }
        return accounts;
    }
}

