/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.material.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.dao.MaterialCategoryMapper;
import com.els.base.material.entity.MaterialCategory;
import com.els.base.material.entity.MaterialCategoryExample;
import com.els.base.material.service.MaterialCategoryService;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="materialCategoryService")
public class MaterialCategoryServiceImpl
implements MaterialCategoryService {
    @Resource
    protected MaterialCategoryMapper materialCategoryMapper;

    @CacheEvict(value={"materialCategory"}, allEntries=true)
    public void addObj(MaterialCategory t) {
        MaterialCategoryExample materialCategoryExample = new MaterialCategoryExample();
        materialCategoryExample.createCriteria().andProjectIdEqualTo(t.getProjectId()).andCategoryCodeEqualTo(t.getCategoryCode()).andIsEnableEqualTo(Constant.YES_INT);
        if (this.materialCategoryMapper.countByExample(materialCategoryExample) > 0) {
            throw new CommonException("\u8be5\u7269\u6599\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728!");
        }
        t.setCreateTime(new Date());
        t.setUpdateTime(new Date());
        this.materialCategoryMapper.insertSelective(t);
    }

    @CacheEvict(value={"materialCategory"}, allEntries=true)
    public void deleteObjById(String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialCategoryMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"materialCategory"}, allEntries=true)
    public void modifyObj(MaterialCategory t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        this.materialCategoryMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"materialCategory"}, keyGenerator="redisKeyGenerator")
    public MaterialCategory queryObjById(String id) {
        return this.materialCategoryMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"materialCategory"}, keyGenerator="redisKeyGenerator")
    public List<MaterialCategory> queryAllObjByExample(MaterialCategoryExample example) {
        return this.materialCategoryMapper.selectByExample(example);
    }

    @Cacheable(value={"materialCategory"}, keyGenerator="redisKeyGenerator")
    public PageView<MaterialCategory> queryObjByPage(MaterialCategoryExample example) {
        PageView<MaterialCategory> pageView = example.getPageView();
        pageView.setQueryResult(this.materialCategoryMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"materialCategory"}, allEntries=true)
    public void deleteCascadedMaterialCategoryInfo(String parentId) {
        if (StringUtils.isBlank((String)parentId)) {
            throw new CommonException("\u4e0a\u4e00\u7ea7\u4f20\u7684id\u4e3a\u7a7a!");
        }
        this.materialCategoryMapper.deleteByPrimaryKey(parentId);
        MaterialCategoryExample materialCategoryExample = new MaterialCategoryExample();
        materialCategoryExample.createCriteria().andParentIdEqualTo(parentId).andIsEnableEqualTo(Constant.YES_INT);
        List<MaterialCategory> list = this.materialCategoryMapper.selectByExample(materialCategoryExample);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (MaterialCategory materialCategory : list) {
            this.deleteCascadedMaterialCategoryInfo(materialCategory.getId());
        }
    }

    @Override
    @Cacheable(value={"materialCategory"}, keyGenerator="redisKeyGenerator")
    public List<MaterialCategory> queryByParentId(String parentId) {
        if (StringUtils.isBlank((String)parentId)) {
            return null;
        }
        MaterialCategoryExample example = new MaterialCategoryExample();
        example.createCriteria().andParentIdEqualTo(parentId).andIsEnableEqualTo(Constant.YES_INT);
        List<MaterialCategory> list = this.materialCategoryMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        for (MaterialCategory materialCategory : list) {
            materialCategory.setMaterialCatergoryList(this.queryByParentId(materialCategory.getId()));
        }
        return list;
    }

    @CacheEvict(value={"materialCategory"}, allEntries=true)
    public void deleteByExample(MaterialCategoryExample example) {
        Assert.isNotNull((Object)((Object)example), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.materialCategoryMapper.deleteByExample(example);
    }

    @CacheEvict(value={"materialCategory"}, allEntries=true)
    @Transactional
    public void addAll(List<MaterialCategory> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.materialCategoryMapper.insertSelective((MaterialCategory)record));
    }
}

