CREATE TABLE `T_BASE_MSG_CONFIG`
(
    `ID`               varchar(32) NOT NULL COMMENT '主键',
    `BUSINESS_TYPE`    varchar(255)  DEFAULT NULL COMMENT '业务类型',
    `UPDATE_USER_ID`   varchar(32)   DEFAULT NULL COMMENT '修改人',
    `UPDATE_USER_NAME` varchar(255)  DEFAULT NULL,
    `UPDATE_TIME`      datetime      DEFAULT NULL COMMENT '修改时间',
    `IS_ENABLE`        decimal(3, 0) DEFAULT NULL COMMENT '是否启用: 0,启用 1,不启用',
    `MSG_LEVEL`        decimal(5, 0) DEFAULT NULL COMMENT '消息级别',
    `SYS_MSG`          decimal(3, 0) DEFAULT NULL COMMENT '是否支持系统消息,1支持0不支持',
    `MAIL_MSG`         decimal(3, 0) DEFAULT NULL COMMENT '是否支持邮箱消息,1支持0不支持',
    `WEIXIN_MSG`       decimal(3, 0) DEFAULT NULL COMMENT '是否支持微信消息,1支持0不支持',
    `SMS_MSG`          decimal(3, 0) DEFAULT NULL COMMENT '是否支持短信消息,1支持0不支持',
    `APP_MSG`          decimal(3, 0) DEFAULT NULL COMMENT '是否支持app端消息,1支持0不支持',
    PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='消息配置';



CREATE TABLE `T_BASE_IM_TEMPLATE`
(
    `ID`               varchar(32) NOT NULL,
    `PROJECT_ID`       varchar(32)  DEFAULT NULL COMMENT '项目id',
    `COMPANY_ID`       varchar(32)  DEFAULT NULL COMMENT 'companyId',
    `TEMPLATE_NO`      varchar(255) DEFAULT NULL COMMENT 'im消息模板号',
    `TEMPLATE_NAME`    varchar(255) DEFAULT NULL COMMENT '模板名称',
    `LANGUAGE`         varchar(255) DEFAULT NULL COMMENT '语言',
    `CREATE_USER`      varchar(255) DEFAULT NULL COMMENT '创建人',
    `CREATE_DATE`      datetime     DEFAULT NULL COMMENT '创建日期',
    `MODIFY_DATE`      datetime     DEFAULT NULL COMMENT '修改日期',
    `TEMPLATE_TITLE`   varchar(255) DEFAULT NULL COMMENT 'im消息标题',
    `BUSINESS_TYPE`    varchar(255) DEFAULT NULL COMMENT '业务类型',
    `PAGE`             varchar(255) DEFAULT NULL COMMENT '跳转页面链接地址',
    `PAGE_PARAM`       text COMMENT '跳转页面链接需要的参数',
    `MESSAGE_FROM`     varchar(255) DEFAULT NULL COMMENT '消息来源',
    `FROM_CODE`        varchar(255) DEFAULT NULL COMMENT '来源公司编码',
    `TEMPLATE_CONTENT` text COMMENT '模板内容',
    PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='im消息模板';


CREATE TABLE `T_BASE_MAIL_ACCOUNT`
(
    `ID`                      varchar(32) NOT NULL COMMENT 'ID',
    `USER_ID`                 varchar(32)   DEFAULT NULL COMMENT '邮箱的拥有者ID',
    `CREATE_USER`             varchar(32)   DEFAULT NULL COMMENT '创建人',
    `CREATE_TIME`             datetime      DEFAULT NULL COMMENT '创建日期',
    `PROJECT_ID`              varchar(32)   DEFAULT NULL COMMENT '项目id',
    `COMPANY_ID`              varchar(32)   DEFAULT NULL COMMENT 'companyId',
    `STMP_SERVER_HOST`        varchar(255)  DEFAULT NULL COMMENT '发邮件服务器地址',
    `STMP_SERVER_PORT`        decimal(5, 0) DEFAULT NULL COMMENT '发邮件服务器端口',
    `STMP_SERVER_IS_SSL`      decimal(1, 0) DEFAULT NULL COMMENT '发邮件服务器地址，是否ssl',
    `MAIL_ADDRESS`            varchar(255)  DEFAULT NULL COMMENT '邮箱地址',
    `PASSWORD`                varchar(255)  DEFAULT NULL COMMENT '密码',
    `REMARK`                  varchar(255)  DEFAULT NULL COMMENT '备注说明',
    `RECEIVE_SERVER_HOST`     varchar(255)  DEFAULT NULL COMMENT '接收服务器地址',
    `RECEIVE_SERVER_PORT`     varchar(255)  DEFAULT NULL COMMENT '接收服务器端口',
    `RECEIVE_SERVER_IS_SSL`   decimal(1, 0) DEFAULT NULL COMMENT '是否选择ssl',
    `RECEIVE_SERVER_PROTOCOL` decimal(1, 0) DEFAULT NULL COMMENT '收件协议，1 pop3,2 imap',
    `COMPANY_NAME`            varchar(255)  DEFAULT NULL COMMENT '公司名称',
    `USER_NAME`               varchar(255)  DEFAULT NULL COMMENT '用户名称',
    `USER_LOGIN_NAME`         varchar(255)  DEFAULT NULL COMMENT '用户登录名',
    `IS_DEFAULT`              decimal(1, 0) DEFAULT NULL COMMENT '是否该公司的默认邮箱',
    `IS_SYSTEM_DEFAULT`       int(11)       DEFAULT NULL COMMENT '是否系统的默认邮箱',
    PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='邮件帐号信息';


CREATE TABLE `T_BASE_MAIL_TEMPLATE`
(
    `ID`               varchar(32) NOT NULL,
    `PROJECT_ID`       varchar(32)  DEFAULT NULL COMMENT '项目id',
    `COMPANY_ID`       varchar(32)  DEFAULT NULL COMMENT 'companyId',
    `TEMPLATE_NUM`     varchar(255) DEFAULT NULL COMMENT '邮件模板号',
    `TEMPLATE_NAME`    varchar(255) DEFAULT NULL COMMENT '模板名称',
    `LANGUAGE`         varchar(255) DEFAULT NULL COMMENT '语言',
    `CREATE_USER`      varchar(255) DEFAULT NULL COMMENT '创建人',
    `TEMPLATE_TITLE`   varchar(255) DEFAULT NULL COMMENT '邮件标题',
    `BUSINESS_TYPE`    varchar(255) DEFAULT NULL COMMENT '业务类型',
    `CREATE_DATE`      datetime     DEFAULT NULL COMMENT '创建日期',
    `MODIFY_DATE`      datetime     DEFAULT NULL COMMENT '修改日期',
    `TEMPLATE_CONTENT` longtext COMMENT '模板内容',
    PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4 COMMENT ='邮件模板信息';

CREATE TABLE `T_BASE_CMS_NOTICE_RECEIVER`
(
    `ID`                  varchar(32) NOT NULL COMMENT '主键',
    `NOTICE_ID`           varchar(32) DEFAULT NULL COMMENT '公告ID',
    `RECEIVER_COMPANY_ID` varchar(32) DEFAULT NULL COMMENT '接收者ID',
    PRIMARY KEY (`ID`) USING BTREE
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  ROW_FORMAT = DYNAMIC;








