/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.sms.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.msg.sms.dao.SmsRecordMapper;
import com.els.base.msg.sms.entity.SmsRecord;
import com.els.base.msg.sms.entity.SmsRecordExample;
import com.els.base.msg.sms.service.SmsRecordService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSmsRecordService")
public class SmsRecordServiceImpl
implements SmsRecordService {
    @Resource
    protected SmsRecordMapper smsRecordMapper;

    @CacheEvict(value={"smsRecord"}, allEntries=true)
    public void addObj(SmsRecord t) {
        this.smsRecordMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"smsRecord"}, allEntries=true)
    public void addAll(List<SmsRecord> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.smsRecordMapper.insertBatch(list);
    }

    @CacheEvict(value={"smsRecord"}, allEntries=true)
    public void deleteObjById(String id) {
        this.smsRecordMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"smsRecord"}, allEntries=true)
    public void deleteByExample(SmsRecordExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.smsRecordMapper.deleteByExample(example);
    }

    @CacheEvict(value={"smsRecord"}, allEntries=true)
    public void modifyObj(SmsRecord t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.smsRecordMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"smsRecord"}, keyGenerator="redisKeyGenerator")
    public SmsRecord queryObjById(String id) {
        return this.smsRecordMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"smsRecord"}, keyGenerator="redisKeyGenerator")
    public List<SmsRecord> queryAllObjByExample(SmsRecordExample example) {
        return this.smsRecordMapper.selectByExample(example);
    }

    @Cacheable(value={"smsRecord"}, keyGenerator="redisKeyGenerator")
    public PageView<SmsRecord> queryObjByPage(SmsRecordExample example) {
        PageView<SmsRecord> pageView = example.getPageView();
        pageView.setQueryResult(this.smsRecordMapper.selectByExampleByPage(example));
        return pageView;
    }
}

