/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.sms.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.msg.sms.dao.SmsTemplateMapper;
import com.els.base.msg.sms.entity.SmsTemplate;
import com.els.base.msg.sms.entity.SmsTemplateExample;
import com.els.base.msg.sms.service.SmsTemplateService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultSmsTemplateService")
public class SmsTemplateServiceImpl
implements SmsTemplateService {
    @Resource
    protected SmsTemplateMapper smsTemplateMapper;

    @CacheEvict(value={"smsTemplate"}, allEntries=true)
    public void addObj(SmsTemplate t) {
        this.smsTemplateMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"smsTemplate"}, allEntries=true)
    public void addAll(List<SmsTemplate> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.smsTemplateMapper.insertBatch(list);
    }

    @CacheEvict(value={"smsTemplate"}, allEntries=true)
    public void deleteObjById(String id) {
        this.smsTemplateMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"smsTemplate"}, allEntries=true)
    public void deleteByExample(SmsTemplateExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.smsTemplateMapper.deleteByExample(example);
    }

    @CacheEvict(value={"smsTemplate"}, allEntries=true)
    public void modifyObj(SmsTemplate t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.smsTemplateMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"smsTemplate"}, keyGenerator="redisKeyGenerator")
    public SmsTemplate queryObjById(String id) {
        return this.smsTemplateMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"smsTemplate"}, keyGenerator="redisKeyGenerator")
    public List<SmsTemplate> queryAllObjByExample(SmsTemplateExample example) {
        return this.smsTemplateMapper.selectByExample(example);
    }

    @Cacheable(value={"smsTemplate"}, keyGenerator="redisKeyGenerator")
    public PageView<SmsTemplate> queryObjByPage(SmsTemplateExample example) {
        PageView<SmsTemplate> pageView = example.getPageView();
        pageView.setQueryResult(this.smsTemplateMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"smsTemplate"}, keyGenerator="redisKeyGenerator")
    public SmsTemplate querySmsTemplateByBusinessType(String businessType) {
        SmsTemplateExample smsTemplateExample = new SmsTemplateExample();
        smsTemplateExample.or().andBusinessTypeEqualTo(businessType);
        List<SmsTemplate> smsTemplateList = this.smsTemplateMapper.selectByExample(smsTemplateExample);
        return CollectionUtils.isEmpty(smsTemplateList) ? null : smsTemplateList.get(0);
    }
}

