/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.common.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.msg.common.entity.MsgConfig;
import com.els.base.msg.common.entity.MsgConfigExample;
import com.els.base.msg.common.service.MsgConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u6d88\u606f\u53d1\u9001\u914d\u7f6e"})
@Controller
@RequestMapping(value={"msgConfig"})
public class MsgConfigController {
    @Resource
    protected MsgConfigService msgConfigService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6d88\u606f\u53d1\u9001\u914d\u7f6e")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MsgConfig msgConfig) {
        Assert.isNotBlank((String)msgConfig.getBusinessType(), (String)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (!msgConfig.getBusinessType().matches("[\\w\\_]+")) {
            throw new CommonException("\u4e1a\u52a1\u7c7b\u578b\u7684\u683c\u5f0f\u9519\u8bef");
        }
        msgConfig.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
        msgConfig.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        this.msgConfigService.addObj(msgConfig);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u6d88\u606f\u53d1\u9001\u914d\u7f6e")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<MsgConfig> msgConfigList) {
        if (CollectionUtils.isEmpty(msgConfigList)) {
            throw new CommonException("id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        }
        for (MsgConfig msgConfig : msgConfigList) {
            if (!msgConfig.getBusinessType().matches("[\\w\\_]+")) {
                throw new CommonException("\u4e1a\u52a1\u7c7b\u578b\u7684\u683c\u5f0f\u9519\u8bef");
            }
            msgConfig.setUpdateUserId(SpringSecurityUtils.getLoginUserId());
            msgConfig.setUpdateUserName(SpringSecurityUtils.getLoginUserName());
        }
        this.msgConfigService.modifyObj(msgConfigList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6279\u91cf\u7981\u7528\u6d88\u606f\u53d1\u9001\u914d\u7f6e")
    @RequestMapping(value={"service/disableMsgConfig"})
    @ResponseBody
    public ResponseResult<String> disableMsgConfig(@RequestBody(required=true) List<String> ids, int isEnable) {
        Assert.isNotEmpty(ids, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        this.msgConfigService.disableMsgConfig(ids, isEnable);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6d88\u606f\u53d1\u9001\u914d\u7f6e")
    @RequestMapping(value={"service/deleteById"})
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank((String)id)) {
            throw new CommonException("\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.msgConfigService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u6d88\u606f\u53d1\u9001\u914d\u7f6e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MsgConfig", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<MsgConfig>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        MsgConfigExample example = new MsgConfigExample();
        example.setPageView((PageView<MsgConfig>)new PageView(pageNo, pageSize));
        if (wapper != null) {
            MsgConfigExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)wapper);
        }
        PageView pageData = this.msgConfigService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

