/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.sms;

import com.els.base.core.entity.user.User;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Assert;
import com.els.base.msg.IMessage;
import com.els.base.msg.IMessageCommand;
import com.els.base.msg.sms.entity.SmsTemplate;
import com.els.base.msg.sms.service.SmsTemplateService;
import com.els.base.msg.sms.util.AliyunSmsSendUtils;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.template.BeetlTemplateUtils;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShortMessageCommand
implements IMessageCommand {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(ShortMessageCommand.class);
    private static UserService userService;
    private static SmsTemplateService smsTemplateService;

    protected static UserService getUserService() {
        if (userService == null) {
            userService = (UserService)SpringContextHolder.getOneBean(UserService.class);
        }
        return userService;
    }

    protected static SmsTemplateService getSmsTemplateService() {
        if (smsTemplateService == null) {
            smsTemplateService = (SmsTemplateService)SpringContextHolder.getOneBean(SmsTemplateService.class);
        }
        return smsTemplateService;
    }

    @Override
    public void sendMsg(IMessage<?> message) throws Exception {
        String typeCode = message.getBusinessTypeCode();
        List<String> receiverIdList = message.getReceiverIdList();
        if (CollectionUtils.isEmpty(receiverIdList)) {
            logger.warn("\u63a5\u6536\u4eba\u7684\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f");
            return;
        }
        SmsTemplate smsTemplate = ShortMessageCommand.getSmsTemplateService().querySmsTemplateByBusinessType(typeCode);
        Assert.isNotNull((Object)smsTemplate, (String)("\u672a\u914d\u7f6e\u7f16\u7801\u4e3a " + typeCode + " \u7684SMS\u6d88\u606f\u6a21\u677f\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f"));
        for (String receiveId : receiverIdList) {
            User receiver = (User)ShortMessageCommand.getUserService().queryObjById((Object)receiveId);
            if (receiver == null) {
                logger.warn("\u63a5\u6536\u4eba\u4e0d\u5b58\u5728,\u65e0\u6cd5\u53d1\u9001\u6d88\u606f,\u63a5\u6536\u4ebaID: {}", (Object)receiveId);
                continue;
            }
            if (StringUtils.isBlank((String)receiver.getMobilePhone())) {
                logger.warn("\u63a5\u6536\u4eba\u672a\u7ed1\u5b9a\u624b\u673a\u53f7\u7801,\u65e0\u6cd5\u53d1\u9001\u6d88\u606f");
                continue;
            }
            this.sendMsg(receiver.getMobilePhone(), smsTemplate, message.getData());
        }
    }

    protected void sendMsg(String moblie, SmsTemplate smsTemplate, Object msgData) {
        String msgContent = null;
        try {
            msgContent = BeetlTemplateUtils.renderFromString((String)smsTemplate.getTemplateContent(), (String)"message", (Object)msgData);
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528\u6a21\u677f\u751f\u6210\u77ed\u4fe1\u5185\u5bb9\u5931\u8d25", (Throwable)e);
        }
        AliyunSmsSendUtils.sendMsg(moblie, smsTemplate.getTemplateNo(), msgContent);
    }
}

