/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.sms.util;

import com.alibaba.druid.filter.config.ConfigTools;
import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.els.base.msg.sms.entity.SmsRecord;
import com.els.base.msg.sms.service.SmsRecordService;
import com.els.base.msg.sms.util.SmsSendUtils;
import com.els.base.utils.SpringContextHolder;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class AliyunSmsSendUtils {
    private static final Logger logger = LoggerFactory.getLogger(SmsSendUtils.class);
    private static final String ACCESS_KEY_ID;
    private static final String ACCESS_KEY_SECRET;
    private static final String DOMAIN;
    private static final String VERSION;
    private static final String ACTION = "SendSms";
    private static final String REGION_ID;
    private static final String SIGN_NAME;
    private static SmsRecordService smsRecordService;

    public static SmsRecordService getSmsRecordService() {
        if (smsRecordService == null) {
            smsRecordService = (SmsRecordService)SpringContextHolder.getOneBean(SmsRecordService.class);
        }
        return smsRecordService;
    }

    private AliyunSmsSendUtils() {
        throw new AssertionError((Object)"No com.els.base.msg.sms.util.AliyunSmsSendUtils instances for you!");
    }

    public static void sendMsg(String mobile, String templateCode, String templateParam) {
        try {
            logger.debug("======== \u5f00\u59cb\u53d1\u9001\u77ed\u4fe1 ========");
            AliyunSmsSendUtils.doSendMsg(mobile, templateCode, templateParam);
            logger.debug("======== \u53d1\u9001\u77ed\u4fe1\u6210\u529f ========");
            AliyunSmsSendUtils.addSendRecord(mobile, templateParam, 1, null);
        }
        catch (Exception e) {
            logger.debug("======== \u53d1\u9001\u77ed\u4fe1\u5931\u8d25 ========", (Throwable)e);
            AliyunSmsSendUtils.addSendRecord(mobile, templateParam, 0, e.getMessage());
        }
    }

    private static void doSendMsg(String mobile, String templateCode, String templateParam) throws ServerException, ClientException {
        DefaultProfile profile = DefaultProfile.getProfile((String)"cn-hangzhou", (String)ACCESS_KEY_ID, (String)ACCESS_KEY_SECRET);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain(DOMAIN);
        request.setVersion(VERSION);
        request.setAction(ACTION);
        request.putQueryParameter("RegionId", REGION_ID);
        request.putQueryParameter("PhoneNumbers", mobile);
        request.putQueryParameter("SignName", SIGN_NAME);
        request.putQueryParameter("TemplateCode", templateCode);
        request.putQueryParameter("TemplateParam", templateParam);
        CommonResponse response = client.getCommonResponse(request);
        logger.debug("response: {}", (Object)response.getData());
    }

    private static void addSendRecord(String mobile, String content, int sendStatus, String cause) {
        SmsRecord record = new SmsRecord();
        record.setMobile(mobile);
        record.setContent(content);
        record.setSendTime(new Date());
        record.setSendStatus(sendStatus);
        record.setCause(cause);
        try {
            AliyunSmsSendUtils.getSmsRecordService().addObj(record);
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u77ed\u4fe1\u53d1\u9001\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
    }

    private static String decrypt(String cipherSecret) {
        try {
            return ConfigTools.decrypt((String)cipherSecret);
        }
        catch (Exception e) {
            logger.error("\u963f\u91cc\u4e91accessKeySecret\u89e3\u7801\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    static {
        Environment environment = SpringContextHolder.getApplicationContext().getEnvironment();
        ACCESS_KEY_ID = environment.getProperty("aliyun.accessKeyId");
        ACCESS_KEY_SECRET = AliyunSmsSendUtils.decrypt(environment.getProperty("aliyun.accessKeySecret"));
        DOMAIN = environment.getProperty("aliyun.domain");
        VERSION = environment.getProperty("aliyun.version");
        REGION_ID = environment.getProperty("aliyun.regionId");
        SIGN_NAME = environment.getProperty("aliyun.signName");
    }
}

