/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.sms.util;

import com.els.base.msg.sms.entity.SmsRecord;
import com.els.base.msg.sms.service.SmsRecordService;
import com.els.base.utils.SpringContextHolder;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmsSendUtils {
    private static final Logger logger = LoggerFactory.getLogger(SmsSendUtils.class);
    private static SmsRecordService smsRecordService;

    public static SmsRecordService getSmsRecordService() {
        if (smsRecordService == null) {
            smsRecordService = (SmsRecordService)SpringContextHolder.getOneBean(SmsRecordService.class);
        }
        return smsRecordService;
    }

    private SmsSendUtils() {
        throw new AssertionError((Object)"No com.els.base.msg.sms.util.SmsSendUtils instances for you!");
    }

    public static void sendMsg(String mobile, String content) {
        try {
            logger.debug("======== \u5f00\u59cb\u53d1\u9001\u77ed\u4fe1 ========");
            SmsSendUtils.doSendMsg(mobile, content);
            logger.debug("======== \u53d1\u9001\u77ed\u4fe1\u6210\u529f ========");
            SmsSendUtils.addSendRecord(mobile, content, 1, null);
        }
        catch (Exception e) {
            logger.debug("======== \u53d1\u9001\u77ed\u4fe1\u5931\u8d25 ========", (Throwable)e);
            SmsSendUtils.addSendRecord(mobile, content, 0, e.getMessage());
        }
    }

    private static void doSendMsg(String mobile, String content) {
    }

    private static void addSendRecord(String mobile, String content, int sendStatus, String cause) {
        SmsRecord record = new SmsRecord();
        record.setMobile(mobile);
        record.setContent(content);
        record.setSendTime(new Date());
        record.setSendStatus(sendStatus);
        record.setCause(cause);
        try {
            SmsSendUtils.getSmsRecordService().addObj(record);
        }
        catch (Exception e) {
            logger.error("\u6dfb\u52a0\u77ed\u4fe1\u53d1\u9001\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
        }
    }
}

