/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.weixin;

import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Constant;
import com.els.base.msg.IMessage;
import com.els.base.msg.IMessageCommand;
import com.els.base.utils.SpringContextHolder;
import com.els.base.wechat.account.entity.AccountConfig;
import com.els.base.wechat.account.utils.WxAccountConfigUtils;
import com.els.base.wechat.member.entity.WxMember;
import com.els.base.wechat.member.entity.WxMemberExample;
import com.els.base.wechat.member.service.WxMemberService;
import com.els.base.wechat.msg.entity.WxTemplateMessage;
import com.els.base.wechat.msg.service.WxTemplateMessageService;
import com.els.base.wechat.msg.utils.WxMpTemplateMsgUtils;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeixinMessageCommand
implements IMessageCommand {
    private static final Logger logger = LoggerFactory.getLogger(WeixinMessageCommand.class);

    @Override
    public void sendMsg(IMessage<?> message) throws Exception {
        List<String> receiverIdList = message.getReceiverIdList();
        if (CollectionUtils.isEmpty(receiverIdList)) {
            return;
        }
        for (String receiverId : receiverIdList) {
            this.sendMsg(receiverId, message);
        }
    }

    private void sendMsg(String receiverId, IMessage<?> message) {
        String businessType = message.getBusinessTypeCode();
        AccountConfig account = WxAccountConfigUtils.getDefaultAccountFromConfig();
        WxTemplateMessageService templateMessageService = (WxTemplateMessageService)SpringContextHolder.getOneBean(WxTemplateMessageService.class);
        WxTemplateMessage msgTemplate = templateMessageService.queryByAccountAndType(account.getId(), businessType);
        if (msgTemplate == null) {
            logger.warn("\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u56e0\u4e3a\u8be5\u4e1a\u52a1\u7c7b\u578b[" + businessType + "]\u8fd8\u6ca1\u6709\u914d\u7f6e\u6a21\u677f");
            return;
        }
        WxMemberExample wxMemberExample = new WxMemberExample();
        wxMemberExample.createCriteria().andMemberIdEqualTo(receiverId);
        WxMemberService wxMemberService = (WxMemberService)SpringContextHolder.getOneBean(WxMemberService.class);
        List list = wxMemberService.queryAllObjByExample((IExample)wxMemberExample);
        if (CollectionUtils.isEmpty((Collection)list)) {
            logger.warn("\u5fae\u4fe1\u6a21\u677f\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u56e0\u4e3a\u8be5\u7528\u6237[" + receiverId + "]\u8fd8\u6ca1\u6709\u5173\u8054\u5fae\u4fe1\u516c\u4f17\u53f7");
            return;
        }
        for (WxMember wxMember : list) {
            if (Constant.NO_INT.equals(wxMember.getWxSubscribe())) {
                logger.warn("\u6d88\u606f\u63a5\u6536\u4eba[" + wxMember.getWxNickname() + "]\uff0c\u8fd8\u6ca1\u6709\u5173\u6ce8\u516c\u4f17\u53f7");
                continue;
            }
            WxMpTemplateMsgUtils.sendWxMpTemplateMessage((AccountConfig)account, (WxTemplateMessage)msgTemplate, message, (String)wxMember.getWxOpenid());
        }
    }
}

