/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.notice.command;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.notice.command.IMsgCommand;
import com.els.base.notice.command.ImInvoker;
import com.els.base.notice.entity.Notice;
import com.els.base.notice.entity.NoticeReceiver;
import com.els.base.notice.entity.NoticeReceiverExample;
import com.els.base.notice.service.NoticeReceiverService;
import com.els.base.notice.service.NoticeService;
import com.els.base.utils.SpringContextHolder;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class ModifyCommand
implements IMsgCommand<String> {
    private Notice notice;
    private Notice originNotcie;

    public ModifyCommand(Notice notice) {
        this.notice = notice;
    }

    @Override
    public String execute(ImInvoker invoker) {
        this.originNotcie = (Notice)this.getNoticeService().queryObjById(this.notice.getId());
        this.init(this.notice);
        this.valid(this.notice);
        this.modify(this.notice);
        return null;
    }

    private NoticeService getNoticeService() {
        return (NoticeService)SpringContextHolder.getOneBean(NoticeService.class);
    }

    private void modify(Notice notice) {
        this.getNoticeService().modifyObj(notice);
        if (Constant.NO_INT.equals(this.originNotcie.getIsAllReceived()) && Constant.YES_INT.equals(this.notice.getIsAllReceived())) {
            NoticeReceiverExample example = new NoticeReceiverExample();
            example.createCriteria().andNoticeIdEqualTo(notice.getId());
            this.getNoticeReceiverService().deleteByExample(example);
            return;
        }
        if (Constant.NO_INT.equals(this.originNotcie.getIsAllReceived()) && CollectionUtils.isNotEmpty(notice.getReceiverIdList())) {
            NoticeReceiverExample example = new NoticeReceiverExample();
            example.createCriteria().andNoticeIdEqualTo(notice.getId());
            this.getNoticeReceiverService().deleteByExample(example);
            ArrayList<String> companyIdList = new ArrayList<String>();
            for (NoticeReceiver company : notice.getReceiverIdList()) {
                companyIdList.add(company.getReceiverCompanyId());
            }
            this.getNoticeReceiverService().addAll(notice.getId(), companyIdList);
            return;
        }
    }

    private NoticeReceiverService getNoticeReceiverService() {
        return (NoticeReceiverService)SpringContextHolder.getOneBean(NoticeReceiverService.class);
    }

    private void init(Notice notice2) {
        notice2.setCreateUserId(null);
        notice2.setCreateTime(null);
        notice2.setCreateUserName(null);
        notice2.setNoticeNo(null);
        ArrayList<NoticeReceiver> blankIds = new ArrayList<NoticeReceiver>();
        if (Constant.NO_INT.equals(this.notice.getIsAllReceived()) && CollectionUtils.isNotEmpty(this.notice.getReceiverIdList())) {
            for (NoticeReceiver receiverId : this.notice.getReceiverIdList()) {
                if (!StringUtils.isBlank((String)receiverId.getReceiverCompanyId())) continue;
                blankIds.add(receiverId);
            }
            this.notice.getReceiverIdList().removeAll(blankIds);
        }
    }

    private void valid(Notice notice) {
        if (this.originNotcie == null) {
            throw new CommonException("\u8be5\u516c\u544a\u4e0d\u5b58\u5728");
        }
        if (notice.getValidStartTime() != null && notice.getValidEndTime() != null && notice.getValidStartTime().getTime() > notice.getValidEndTime().getTime()) {
            throw new CommonException("\u5f00\u59cb\u751f\u6548\u65f6\u95f4\uff0c\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4");
        }
        if (Constant.YES_INT.equals(this.originNotcie.getIsAllReceived()) && Constant.NO_INT.equals(this.notice.getIsAllReceived()) && CollectionUtils.isEmpty(this.notice.getReceiverIdList())) {
            throw new CommonException("\u6307\u5b9a\u7684\u63a5\u6536\u65b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

