/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.websitemsg.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.common.entity.MsgConfig;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.websitemsg.dao.WebsiteMsgMapper;
import com.els.base.websitemsg.entity.WebsiteMsg;
import com.els.base.websitemsg.entity.WebsiteMsgExample;
import com.els.base.websitemsg.service.WebsiteMsgService;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultWebsiteMsgService")
public class WebsiteMsgServiceImpl
implements WebsiteMsgService {
    @Resource
    protected WebsiteMsgMapper websiteMsgMapper;
    public static final String TYPE_SYSTEM = "system";
    public static final String TYPE_PERSONAL = "personal";

    @Override
    @Cacheable(value={"websiteMsg"}, keyGenerator="redisKeyGenerator")
    public int countByExample(WebsiteMsgExample example) {
        return this.websiteMsgMapper.countByExample(example);
    }

    @CacheEvict(value={"websiteMsg"}, allEntries=true)
    public void addObj(WebsiteMsg t) {
        this.websiteMsgMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"websiteMsg"}, allEntries=true)
    public void addAll(List<WebsiteMsg> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.websiteMsgMapper.insertBatch(list);
    }

    @CacheEvict(value={"websiteMsg"}, allEntries=true)
    public void deleteObjById(String id) {
        this.websiteMsgMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"websiteMsg"}, allEntries=true)
    public void deleteByExample(WebsiteMsgExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.websiteMsgMapper.deleteByExample(example);
    }

    @CacheEvict(value={"websiteMsg"}, allEntries=true)
    public void modifyObj(WebsiteMsg t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.websiteMsgMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"websiteMsg"}, keyGenerator="redisKeyGenerator")
    public WebsiteMsg queryObjById(String id) {
        return this.websiteMsgMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"websiteMsg"}, keyGenerator="redisKeyGenerator")
    public List<WebsiteMsg> queryAllObjByExample(WebsiteMsgExample example) {
        return this.websiteMsgMapper.selectByExample(example);
    }

    @Cacheable(value={"websiteMsg"}, keyGenerator="redisKeyGenerator")
    public PageView<WebsiteMsg> queryObjByPage(WebsiteMsgExample example) {
        PageView<WebsiteMsg> pageView = example.getPageView();
        pageView.setQueryResult(this.websiteMsgMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void createMsg(Message<?> message, String websiteContent, MsgConfig msgConfig) {
        Set<String> accounts = this.getAccount(message.getReceiverIdList());
        String senderId = message.getSenderId();
        MessageLevelEnum msgLevel = message.getMsgLevel();
        String msgType = TYPE_PERSONAL;
        if (StringUtils.isBlank((String)senderId)) {
            senderId = "systemDefaultSender";
            msgType = TYPE_SYSTEM;
        }
        for (String reString : accounts) {
            WebsiteMsg websiteMsg = new WebsiteMsg();
            websiteMsg.setSender(senderId);
            websiteMsg.setReceiverid(reString);
            websiteMsg.setContent(websiteContent);
            websiteMsg.setTitle(msgConfig.getBusinessType());
            websiteMsg.setReader(Constant.NO_INT);
            websiteMsg.setCreateTime(new Date());
            websiteMsg.setUpdateTime(new Date());
            websiteMsg.setType(msgType);
            websiteMsg.setDeleted(Constant.YES_INT);
            websiteMsg.setMsgLevel(msgLevel.getLevel());
            this.websiteMsgMapper.insertSelective(websiteMsg);
        }
    }

    private Set<String> getAccount(List<String> receiverIdList) {
        HashSet<String> accounts = new HashSet<String>();
        for (int i = 0; CollectionUtils.isNotEmpty(receiverIdList) && i < receiverIdList.size(); ++i) {
            accounts.add(receiverIdList.get(i));
        }
        return accounts;
    }
}

