/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.websitemsg.util;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.common.entity.MsgConfig;
import com.els.base.msg.common.service.MsgConfigService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.template.BeetlTemplateUtils;
import com.els.base.websitemsg.entity.WebsiteTemplate;
import com.els.base.websitemsg.service.WebsiteMsgService;
import com.els.base.websitemsg.service.WebsiteTemplateService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsiteMsgUtils {
    private static final Logger logger = LoggerFactory.getLogger(WebsiteMsgUtils.class);

    private static WebsiteTemplateService getWebsiteTemplateService() {
        return (WebsiteTemplateService)SpringContextHolder.getOneBean(WebsiteTemplateService.class);
    }

    private static WebsiteMsgService getWebsiteMsgService() {
        return (WebsiteMsgService)SpringContextHolder.getOneBean(WebsiteMsgService.class);
    }

    private static MsgConfigService getMsgConfigService() {
        return (MsgConfigService)SpringContextHolder.getOneBean(MsgConfigService.class);
    }

    public static void sendMessage(Message<?> message) {
        message.checkDataWebsite();
        List<MsgConfig> msgConfigs = WebsiteMsgUtils.getMsgConfigService().queryWebsiteMsg(message);
        if (CollectionUtils.isEmpty(msgConfigs)) {
            logger.warn("\u6ca1\u6709\u5f00\u542f\u7ad9\u5185\u4fe1\u529f\u80fd");
            return;
        }
        WebsiteMsgUtils.sendMsg(msgConfigs, message);
    }

    private static void sendMsg(List<MsgConfig> msgConfigs, Message<?> message) {
        String businessTypeCode = message.getBusinessTypeCode();
        List<WebsiteTemplate> websiteTemplate = WebsiteMsgUtils.getWebsiteTemplateService().queryWebsiteTemplateByBusinessType(businessTypeCode);
        if (websiteTemplate == null) {
            logger.warn("\u7ad9\u5185\u4fe1\u6d88\u606f\u6a21\u677f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u53d1\u9001\u6d88\u606f");
            return;
        }
        String websiteContent = websiteTemplate.get(0).getTemplateContent();
        try {
            websiteContent = BeetlTemplateUtils.renderFromString((String)websiteContent, (String)"message", message);
        }
        catch (Exception e) {
            logger.error("\u4f7f\u7528\u6a21\u677f\u751f\u6210\u6d88\u606f\u5185\u5bb9\u5931\u8d25", (Throwable)e);
        }
        WebsiteMsgUtils.getWebsiteMsgService().createMsg(message, websiteContent, msgConfigs.get(0));
    }

    public static void main(String[] args) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("orderNo", "10086");
        Message message = Message.init(data).setBusinessTypeCode("TEST").setMsgLevel(MessageLevelEnum.HIGH).setSenderId(SpringSecurityUtils.getLoginUserId()).addReceiverId(SpringSecurityUtils.getLoginUserId()).addReceiverIdList(new ArrayList<String>());
        WebsiteMsgUtils.sendMessage(message);
    }
}

