-- ----------------------------
-- 消息配置
-- ----------------------------
-- DROP TABLE "T_BASE_MSG_CONFIG";
CREATE TABLE "T_BASE_MSG_CONFIG"
(
    "ID"               VARCHAR2(32 BYTE) NOT NULL,
    "BUSINESS_TYPE"    VARCHAR2(255 BYTE),
    "UPDATE_USER_ID"   VARCHAR2(32 BYTE),
    "UPDATE_USER_NAME" VARCHAR2(255 BYTE),
    "UPDATE_TIME"      DATE DEFAULT sysdate,
    "IS_ENABLE"        NUMBER(3),
    "MSG_LEVEL"        NUMBER(5),
    "SYS_MSG"          NUMBER(3),
    "MAIL_MSG"         NUMBER(3),
    "WEIXIN_MSG"       NUMBER(3),
    "SMS_MSG"          NUMBER(3),
    "APP_MSG"          NUMBER(3)
);

COMMENT ON COLUMN "T_BASE_MSG_CONFIG"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_MSG_CONFIG"."BUSINESS_TYPE" IS '业务类型';
COMMENT ON COLUMN "T_BASE_MSG_CONFIG"."UPDATE_USER_ID" IS '修改人';
COMMENT ON COLUMN "T_BASE_MSG_CONFIG"."UPDATE_USER_NAME" IS '修改人名称';
COMMENT ON COLUMN "T_BASE_MSG_CONFIG"."UPDATE_TIME" IS '修改时间';
COMMENT ON COLUMN "T_BASE_MSG_CONFIG"."IS_ENABLE" IS '是否启用: 0,启用 1,不启用';
COMMENT ON COLUMN "T_BASE_MSG_CONFIG"."MSG_LEVEL" IS '消息级别';
COMMENT ON COLUMN "T_BASE_MSG_CONFIG"."SYS_MSG" IS '是否支持系统消息,1支持0不支持';
COMMENT ON COLUMN "T_BASE_MSG_CONFIG"."MAIL_MSG" IS '是否支持邮箱消息,1支持0不支持';
COMMENT ON COLUMN "T_BASE_MSG_CONFIG"."WEIXIN_MSG" IS '是否支持微信消息,1支持0不支持';
COMMENT ON COLUMN "T_BASE_MSG_CONFIG"."SMS_MSG" IS '是否支持短信消息,1支持0不支持';
COMMENT ON COLUMN "T_BASE_MSG_CONFIG"."APP_MSG" IS '是否支持app端消息,1支持0不支持';

ALTER TABLE "T_BASE_MSG_CONFIG"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- im消息模板
-- ----------------------------
-- DROP TABLE "T_BASE_IM_TEMPLATE";
CREATE TABLE "T_BASE_IM_TEMPLATE"
(
    "ID"               VARCHAR2(32 BYTE) NOT NULL,
    "PROJECT_ID"       VARCHAR2(32 BYTE),
    "COMPANY_ID"       VARCHAR2(32 BYTE),
    "TEMPLATE_NO"      VARCHAR2(255 BYTE),
    "TEMPLATE_NAME"    VARCHAR2(255 BYTE),
    "LANGUAGE"         VARCHAR2(255 BYTE),
    "CREATE_USER"      VARCHAR2(255 BYTE),
    "CREATE_DATE"      DATE DEFAULT sysdate,
    "MODIFY_DATE"      DATE,
    "TEMPLATE_TITLE"   VARCHAR2(255 BYTE),
    "BUSINESS_TYPE"    VARCHAR2(255 BYTE),
    "PAGE"             VARCHAR2(255 BYTE),
    "PAGE_PARAM"       VARCHAR2(500 BYTE),
    "MESSAGE_FROM"     VARCHAR2(255 BYTE),
    "FROM_CODE"        VARCHAR2(255 BYTE),
    "TEMPLATE_CONTENT" VARCHAR2(2000 BYTE)
);

COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."COMPANY_ID" IS 'companyId';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."TEMPLATE_NO" IS 'im消息模板号';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."TEMPLATE_NAME" IS '模板名称';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."LANGUAGE" IS '语言';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."CREATE_USER" IS '创建人';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."CREATE_DATE" IS '创建日期';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."MODIFY_DATE" IS '修改日期';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."TEMPLATE_TITLE" IS 'im消息标题';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."BUSINESS_TYPE" IS '业务类型';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."PAGE" IS '跳转页面链接地址';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."PAGE_PARAM" IS '跳转页面链接需要的参数';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."MESSAGE_FROM" IS '消息来源';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."FROM_CODE" IS '来源公司编码';
COMMENT ON COLUMN "T_BASE_IM_TEMPLATE"."TEMPLATE_CONTENT" IS '模板内容';
COMMENT ON TABLE "T_BASE_IM_TEMPLATE" IS 'im消息模板';

ALTER TABLE "T_BASE_IM_TEMPLATE"
    ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 邮件帐号信息
-- ----------------------------
-- DROP TABLE "T_BASE_MAIL_ACCOUNT";
CREATE TABLE "T_BASE_MAIL_ACCOUNT"
(
    "ID"                      VARCHAR2(32 BYTE) NOT NULL,
    "USER_ID"                 VARCHAR2(32 BYTE),
    "CREATE_USER"             VARCHAR2(32 BYTE),
    "CREATE_TIME"             DATE DEFAULT sysdate,
    "PROJECT_ID"              VARCHAR2(32 BYTE),
    "COMPANY_ID"              VARCHAR2(32 BYTE),
    "STMP_SERVER_HOST"        VARCHAR2(255 BYTE),
    "STMP_SERVER_PORT"        NUMBER(5),
    "STMP_SERVER_IS_SSL"      NUMBER(1),
    "MAIL_ADDRESS"            VARCHAR2(255 BYTE),
    "PASSWORD"                VARCHAR2(255 BYTE),
    "REMARK"                  VARCHAR2(255 BYTE),
    "RECEIVE_SERVER_HOST"     VARCHAR2(255 BYTE),
    "RECEIVE_SERVER_PORT"     VARCHAR2(255 BYTE),
    "RECEIVE_SERVER_IS_SSL"   NUMBER(1),
    "RECEIVE_SERVER_PROTOCOL" NUMBER(1),
    "COMPANY_NAME"            VARCHAR2(255 BYTE),
    "USER_NAME"               VARCHAR2(255 BYTE),
    "USER_LOGIN_NAME"         VARCHAR2(255 BYTE),
    "IS_DEFAULT"              NUMBER(1),
    "IS_SYSTEM_DEFAULT"       NUMBER(1)
);

COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."USER_ID" IS '邮箱的拥有者ID';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."CREATE_USER" IS '创建人';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."CREATE_TIME" IS '创建日期';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."COMPANY_ID" IS 'companyId';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."STMP_SERVER_HOST" IS '发邮件服务器地址';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."STMP_SERVER_PORT" IS '发邮件服务器端口';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."STMP_SERVER_IS_SSL" IS '发邮件服务器地址，是否ssl';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."MAIL_ADDRESS" IS '邮箱地址';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."PASSWORD" IS '密码';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."REMARK" IS '备注说明';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."RECEIVE_SERVER_HOST" IS '接收服务器地址';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."RECEIVE_SERVER_PORT" IS '接收服务器端口';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."RECEIVE_SERVER_IS_SSL" IS '是否选择ssl';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."RECEIVE_SERVER_PROTOCOL" IS '收件协议，1 pop3,2 imap';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."COMPANY_NAME" IS '公司名称';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."USER_NAME" IS '用户名称';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."USER_LOGIN_NAME" IS '用户登录名';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."IS_DEFAULT" IS '是否该公司的默认邮箱';
COMMENT ON COLUMN "T_BASE_MAIL_ACCOUNT"."IS_SYSTEM_DEFAULT" IS '是否系统的默认邮箱';
COMMENT ON TABLE "T_BASE_MAIL_ACCOUNT" IS '邮件帐号信息';

ALTER TABLE "T_BASE_MAIL_ACCOUNT" ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 邮件模板信息
-- ----------------------------
-- DROP TABLE "T_BASE_MAIL_TEMPLATE";
CREATE TABLE "T_BASE_MAIL_TEMPLATE"
(
    "ID"               VARCHAR2(32 BYTE) NOT NULL,
    "PROJECT_ID"       VARCHAR2(32 BYTE),
    "COMPANY_ID"       VARCHAR2(32 BYTE),
    "TEMPLATE_NUM"     VARCHAR2(255 BYTE),
    "TEMPLATE_NAME"    VARCHAR2(255 BYTE),
    "LANGUAGE"         VARCHAR2(255 BYTE),
    "CREATE_USER"      VARCHAR2(255 BYTE),
    "TEMPLATE_TITLE"   VARCHAR2(255 BYTE),
    "BUSINESS_TYPE"    VARCHAR2(255 BYTE),
    "CREATE_DATE"      DATE DEFAULT sysdate,
    "MODIFY_DATE"      DATE DEFAULT sysdate,
    "TEMPLATE_CONTENT" CLOB
);

COMMENT ON COLUMN "T_BASE_MAIL_TEMPLATE"."ID" IS 'ID';
COMMENT ON COLUMN "T_BASE_MAIL_TEMPLATE"."PROJECT_ID" IS '项目id';
COMMENT ON COLUMN "T_BASE_MAIL_TEMPLATE"."COMPANY_ID" IS 'companyId';
COMMENT ON COLUMN "T_BASE_MAIL_TEMPLATE"."TEMPLATE_NUM" IS '邮件模板号';
COMMENT ON COLUMN "T_BASE_MAIL_TEMPLATE"."TEMPLATE_NAME" IS '模板名称';
COMMENT ON COLUMN "T_BASE_MAIL_TEMPLATE"."LANGUAGE" IS '语言';
COMMENT ON COLUMN "T_BASE_MAIL_TEMPLATE"."CREATE_USER" IS '创建人';
COMMENT ON COLUMN "T_BASE_MAIL_TEMPLATE"."TEMPLATE_TITLE" IS '邮件标题';
COMMENT ON COLUMN "T_BASE_MAIL_TEMPLATE"."BUSINESS_TYPE" IS '业务类型';
COMMENT ON COLUMN "T_BASE_MAIL_TEMPLATE"."CREATE_DATE" IS '创建日期';
COMMENT ON COLUMN "T_BASE_MAIL_TEMPLATE"."MODIFY_DATE" IS '修改日期';
COMMENT ON COLUMN "T_BASE_MAIL_TEMPLATE"."TEMPLATE_CONTENT" IS '模板内容';
COMMENT ON TABLE "T_BASE_MAIL_TEMPLATE" IS '邮件模板信息';

ALTER TABLE "T_BASE_MAIL_TEMPLATE"
    ADD PRIMARY KEY ("ID");


-- ----------------------------
-- 公告通知表
-- ----------------------------
-- DROP TABLE "T_BASE_CMS_NOTICE";
CREATE TABLE "T_BASE_CMS_NOTICE"
(
    "ID"                VARCHAR2(32 BYTE) NOT NULL,
    "TITLE"             VARCHAR2(255 BYTE),
    "TYPE"              VARCHAR2(20 BYTE),
    "STATUS"            NUMBER(2),
    "PUBLISH_TIME"      DATE,
    "CREATE_TIME"       DATE,
    "IS_ALL_RECEIVED"   NUMBER(5),
    "ATTACHMENT"        VARCHAR2(1024 BYTE),
    "CREATE_USER_ID"    VARCHAR2(32 BYTE),
    "CREATE_USER_NAME"  VARCHAR2(255 BYTE),
    "VALID_START_TIME"  DATE,
    "VALID_END_TIME"    DATE,
    "PUBLISH_USER_ID"   VARCHAR2(32 BYTE),
    "PUBLISH_USER_NAME" VARCHAR2(255 BYTE),
    "NOTICE_NO"         VARCHAR2(32 BYTE),
    "CONTENT"           CLOB,
    "STICK"             NUMBER(7),
    "ATTACHMENTS"       CLOB,
    "CONTENTS"          CLOB
);

COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."TITLE" IS '标题';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."TYPE" IS '类型（参考字典NOTICE_TYPE）';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."STATUS" IS '发布状态（0未发布，1已发布）';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."PUBLISH_TIME" IS '发布时间';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."IS_ALL_RECEIVED" IS '是否是发给所有人，0不是，1是';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."ATTACHMENT" IS '附件';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."CREATE_USER_ID" IS '创建人id';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."CREATE_USER_NAME" IS '创建人名称';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."VALID_START_TIME" IS '生效期开始时间';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."VALID_END_TIME" IS '生效期结束时间';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."PUBLISH_USER_ID" IS '发布人id';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."PUBLISH_USER_NAME" IS '发布人名称';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."NOTICE_NO" IS '公告编码';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."CONTENT" IS '内容';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."STICK" IS '是否置顶';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."ATTACHMENTS" IS '附件';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE"."CONTENTS" IS '内容';
COMMENT ON TABLE "T_BASE_CMS_NOTICE" IS '公告通知表';


ALTER TABLE "T_BASE_CMS_NOTICE" ADD PRIMARY KEY ("ID");



-- ----------------------------
-- 公告与收件者关系表
-- ----------------------------
-- DROP TABLE "T_BASE_CMS_NOTICE_RECEIVER";
CREATE TABLE "T_BASE_CMS_NOTICE_RECEIVER"
(
    "ID"                  VARCHAR2(32 BYTE) NOT NULL,
    "NOTICE_ID"           VARCHAR2(32 BYTE),
    "RECEIVER_COMPANY_ID" VARCHAR2(32 BYTE)
);

COMMENT ON COLUMN "T_BASE_CMS_NOTICE_RECEIVER"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE_RECEIVER"."NOTICE_ID" IS '公告ID';
COMMENT ON COLUMN "T_BASE_CMS_NOTICE_RECEIVER"."RECEIVER_COMPANY_ID" IS '接收者ID';
COMMENT ON TABLE "T_BASE_CMS_NOTICE_RECEIVER" IS '公告与收件者关系表';


ALTER TABLE "T_BASE_CMS_NOTICE_RECEIVER" ADD PRIMARY KEY ("ID");

