/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.msg.mail.utils;

import com.els.base.core.utils.Constant;
import com.els.base.msg.mail.entity.MailAccount;
import com.els.base.utils.encryption.DESUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;

public class SmtpSendUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SmtpSendUtils.class);

    public static void sendMail(MailAccount senderMailAccount, String receiveEmailAddress, String receiveName, String subject, String mailContent) throws Exception {
        String smtpHost = senderMailAccount.getStmpServerHost();
        Integer smtpPort = senderMailAccount.getStmpServerPort();
        boolean isSSL = !Constant.NO_INT.equals(senderMailAccount.getStmpServerIsSsl());
        String senderMailAddress = senderMailAccount.getMailAddress();
        String password = senderMailAccount.getPassword();
        password = DESUtils.decrypt((String)password, (String)"tissonco");
        String senderName = senderMailAccount.getUserName();
        SmtpSendUtils.sendMail(smtpHost, smtpPort, isSSL, senderMailAddress, password, senderName, receiveEmailAddress, receiveName, subject, mailContent, null);
    }

    public static void sendMail(String smtpHost, int smtpPort, boolean isSSL, String senderMailAddress, String password, String senderName, String receiveEmailAddress, String receiveName, String subject, String mailContent, File attachment) throws MessagingException, UnsupportedEncodingException {
        Properties properties = new Properties();
        properties.setProperty("mail.debug", "true");
        properties.setProperty("mail.smtp.timeout", "1000");
        properties.setProperty("mail.smtp.port", String.valueOf(smtpPort));
        properties.setProperty("mail.smtp.socketFactory.fallback", "false");
        if (isSSL) {
            properties.setProperty("mail.smtp.auth", "false");
            properties.setProperty("mail.smtp.socketFactory.port", String.valueOf(smtpPort));
            properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(smtpHost);
        sender.setPort(smtpPort);
        LOGGER.info("userName" + senderMailAddress);
        LOGGER.info("password" + password);
        sender.setUsername(senderMailAddress);
        sender.setPassword(password);
        sender.setDefaultEncoding("UTF-8");
        sender.setJavaMailProperties(properties);
        LOGGER.info("\u51c6\u5907\u521b\u5efaMimeMessage");
        MimeMessage message = sender.createMimeMessage();
        LOGGER.info("\u521b\u5efaMimeMessage\u6210\u529f");
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        helper.setFrom(new InternetAddress(senderMailAddress, senderName, "UTF-8"));
        helper.setTo(new InternetAddress(receiveEmailAddress, receiveName, "UTF-8"));
        helper.setSubject(subject);
        helper.setText(mailContent, true);
        if (attachment != null) {
            helper.addAttachment(attachment.getName(), attachment);
        }
        LOGGER.info("\u6d4b\u8bd5\u90ae\u7bb1\u94fe\u63a5");
        sender.testConnection();
        LOGGER.info("\u53d1\u9001\u90ae\u7bb1\uff01\uff01");
        sender.send(message);
    }

    public static void testConnection(MailAccount senderMailAccount) throws Exception {
        String smtpHost = senderMailAccount.getStmpServerHost();
        Integer smtpPort = senderMailAccount.getStmpServerPort();
        boolean isSSL = !Constant.NO_INT.equals(senderMailAccount.getStmpServerIsSsl());
        String senderMailAddress = senderMailAccount.getMailAddress();
        String password = senderMailAccount.getPassword();
        password = DESUtils.decrypt((String)password, (String)"tissonco");
        SmtpSendUtils.testConnection(smtpHost, smtpPort, isSSL, senderMailAddress, password);
    }

    public static void testConnection(String smtpHost, int smtpPort, boolean isSSL, String senderMailAddress, String password) throws MessagingException {
        Properties properties = new Properties();
        properties.setProperty("mail.debug", "true");
        properties.setProperty("mail.smtp.timeout", "1000");
        properties.setProperty("mail.smtp.port", String.valueOf(smtpPort));
        properties.setProperty("mail.smtp.socketFactory.fallback", "false");
        if (isSSL) {
            properties.setProperty("mail.smtp.auth", "true");
            properties.setProperty("mail.smtp.socketFactory.port", String.valueOf(smtpPort));
            properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(smtpHost);
        sender.setPort(smtpPort);
        sender.setUsername(senderMailAddress);
        sender.setPassword(password);
        sender.setDefaultEncoding("UTF-8");
        sender.setJavaMailProperties(properties);
        sender.testConnection();
    }
}

