package com.els.base.core.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import com.els.base.core.web.interceptor.ProjectInitInterceptor;

@Configuration
public class BaseModuleMvcConfiguration extends WebMvcConfigurerAdapter {

	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		registry.addInterceptor(this.getProjectInterceptor()).addPathPatterns("/**");
		super.addInterceptors(registry);
	}

	@Bean
	public HandlerInterceptor getProjectInterceptor() {
		return new ProjectInitInterceptor();
	}
}
