package com.els.base.core.entity.project;

import java.io.Serializable;
import java.util.Date;

import com.els.base.core.utils.Assert;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value = "项目")
public class Project implements Serializable {

    /** 以下代码非自动生成,请勿覆盖 **/
    public String getLoginSuccessPage() {
        Assert.isNotBlank(getProjectRoute(), "项目路由不能为空");
        if (getProjectRoute().contains(";")) {
            return getProjectRoute().split(";")[0];
        } else {
            return getProjectRoute();
        }
    }

    public String getLogoutSuccessPage() {
        Assert.isNotBlank(getProjectRoute(), "项目路由不能为空");
        if (getProjectRoute().contains(";")) {
            return getProjectRoute().split(";")[1];
        } else {
            return null;
        }
    }

    /** --------- **/

    @ApiModelProperty("主键")
    private String id;

    @ApiModelProperty("项目编码")
    private String projectCode;

    @ApiModelProperty("项目名称")
    private String projectName;

    @ApiModelProperty("项目简介")
    private String projectDesc;

    @ApiModelProperty("项目域名")
    private String projectDomain;

    @ApiModelProperty("项目路由")
    private String projectRoute;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("是否已删除：0否，1是")
    private Boolean isDelete;

    @ApiModelProperty("采购公司ID")
    private String companyId;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode == null ? null : projectCode.trim();
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName == null ? null : projectName.trim();
    }

    public String getProjectDesc() {
        return projectDesc;
    }

    public void setProjectDesc(String projectDesc) {
        this.projectDesc = projectDesc == null ? null : projectDesc.trim();
    }

    public String getProjectDomain() {
        return projectDomain;
    }

    public void setProjectDomain(String projectDomain) {
        this.projectDomain = projectDomain == null ? null : projectDomain.trim();
    }

    public String getProjectRoute() {
        return projectRoute;
    }

    public void setProjectRoute(String projectRoute) {
        this.projectRoute = projectRoute == null ? null : projectRoute.trim();
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }
}