package com.els.base.core.web.controller.dictionary;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.dictionary.DicGroup;
import com.els.base.core.entity.dictionary.DicGroupItem;
import com.els.base.core.entity.dictionary.DicGroupItemExample;
import com.els.base.core.service.dictionary.DicGroupItemService;
import com.els.base.core.service.dictionary.DicGroupService;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import springfox.documentation.annotations.ApiIgnore;

@Api(value = "字典组子项")
@Controller
@RequestMapping("dicGroupItem")
public class DicGroupItemController {

    @Resource
    protected DicGroupItemService dicGroupItemService;

    @Resource
    protected DicGroupService dicGroupService;

    @ApiIgnore
    @RequestMapping("service/toAddView")
    public ModelAndView toAddView(String dicGroupId) {
        ModelAndView view = new ModelAndView();
        view.setViewName("base/dictionary/dicGroupItem/toAddView");
        DicGroup dicGroup = this.dicGroupService.queryObjById(dicGroupId);
        view.addObject("dicGroup", dicGroup);
        return view;
    }

    @ApiIgnore
    @RequestMapping("service/toUpdateViewById")
    public ModelAndView toDicGroupById(String id) {
        ModelAndView view = new ModelAndView();
        DicGroupItem dicGroupItem = null;
        dicGroupItem = this.dicGroupItemService.queryObjById(id);
        view.addObject("dicGroupItem", dicGroupItem);
        DicGroup dicGroup = this.dicGroupService.queryObjById(dicGroupItem.getGroupId());
        view.addObject("dicGroup", dicGroup);
        view.setViewName("base/dictionary/dicGroupItem/toAddView");
        return view;
    }

    @ApiIgnore
    @RequestMapping("service/toListPageView")
    public ModelAndView toListPageView(String dicGroupId) {
        ModelAndView view = new ModelAndView();
        view.setViewName("base/dictionary/dicGroupItem/listPageView");
        DicGroup dicGroup = this.dicGroupService.queryObjById(dicGroupId);
        view.addObject("dicGroup", dicGroup);
        return view;
    }

    @ApiOperation(value = "创建字典组子项", httpMethod = "POST")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody DicGroupItem dicGroupItem) {
        this.dicGroupItemService.addObj(dicGroupItem);
        return ResponseResult.success();
    }

    @ApiOperation(value = "编辑字典组子项", httpMethod = "POST")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody DicGroupItem dicGroupItem) {
    	this.dicGroupItemService.modifyObj(dicGroupItem);
         return ResponseResult.success();
    }

    @ApiOperation(value = "删除字典组子项", httpMethod = "POST")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(String id) {
        this.dicGroupItemService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(value = "分页查询字典组子项", httpMethod = "GET")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<DicGroupItem>> findByPage(@ApiParam(value = "分组id") String dicGroupId,
            @ApiParam(value = "所在页", defaultValue = "1") @RequestParam(defaultValue = "1") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件") @RequestBody(required=false) List<QueryParam> queryParams) {

        DicGroupItemExample example = new DicGroupItemExample();
        example.setPageView(new PageView<DicGroupItem>(pageNo, pageSize));
        DicGroupItemExample.Criteria cri1 = example.createCriteria();
        cri1.andGroupIdEqualTo(dicGroupId);
        if (CollectionUtils.isNotEmpty(queryParams)) {
            CriteriaUtils.addCriterion(cri1, queryParams);
        }
        PageView<DicGroupItem> pageView = this.dicGroupItemService.queryObjByPage(example);
        return ResponseResult.success(pageView);
    }

    @ApiOperation(value = "根据字典组的code值，查询所有子项", httpMethod = "GET")
    @RequestMapping(value = { "service/findByDicGroupCode", "front/findByDicGroupCode" })
    @ResponseBody
    public ResponseResult<List<DicGroupItem>> findByDicGroupCode(String dicGroupCode) {
        List<DicGroupItem> list = this.dicGroupItemService.queryItemsByGroupCode(dicGroupCode);
        return ResponseResult.success(list);
    }

}
