/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.allot.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.allot.dao.MouldAllotMapper;
import com.els.base.mould.allot.entity.AllotItem;
import com.els.base.mould.allot.entity.AllotItemExample;
import com.els.base.mould.allot.entity.MouldAllot;
import com.els.base.mould.allot.entity.MouldAllotExample;
import com.els.base.mould.allot.service.AllotItemService;
import com.els.base.mould.allot.service.MouldAllotService;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.master.utils.MouldStatus;
import com.els.base.mould.utils.MouldBusinessEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultMouldAllotService")
public class MouldAllotServiceImpl
implements MouldAllotService {
    @Resource
    protected MouldAllotMapper mouldAllotMapper;
    @Resource
    protected MouldService mouldService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected AllotItemService allotItemService;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private CompanyUserRefService companyUserRefService;

    @CacheEvict(value={"mouldAllot"}, allEntries=true)
    public void addObj(MouldAllot t) {
        this.mouldAllotMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"mouldAllot"}, allEntries=true)
    public void addAll(List<MouldAllot> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.mouldAllotMapper.insertBatch(list);
    }

    @CacheEvict(value={"mouldAllot"}, allEntries=true)
    public void deleteObjById(String id) {
        this.mouldAllotMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"mouldAllot"}, allEntries=true)
    public void deleteByExample(MouldAllotExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.mouldAllotMapper.deleteByExample(example);
    }

    @CacheEvict(value={"mouldAllot"}, allEntries=true)
    public void modifyObj(MouldAllot t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.mouldAllotMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"mouldAllot"}, keyGenerator="redisKeyGenerator")
    public MouldAllot queryObjById(String id) {
        return this.mouldAllotMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"mouldAllot"}, keyGenerator="redisKeyGenerator")
    public List<MouldAllot> queryAllObjByExample(MouldAllotExample example) {
        return this.mouldAllotMapper.selectByExample(example);
    }

    @Cacheable(value={"mouldAllot"}, keyGenerator="redisKeyGenerator")
    public PageView<MouldAllot> queryObjByPage(MouldAllotExample example) {
        PageView<MouldAllot> pageView = example.getPageView();
        pageView.setQueryResult(this.mouldAllotMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"mouldAllot"}, allEntries=true)
    public MouldAllot prepareForPur(List<String> ids, Company purCompany, com.els.base.auth.entity.User purUser) {
        MouldExample example = new MouldExample();
        example.createCriteria().andIdIn((List)ids);
        List moulds = this.mouldService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)moulds, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5177\u4e3b\u6570\u636e!");
        for (Mould mould : moulds) {
            if (MouldStatus.USABLE.getCode().equals(mould.getMouldStatus())) continue;
            throw new CommonException("\u53ea\u6709\u6a21\u5177\u72b6\u6001\u4e3a\u53ef\u7528\u7684\u6a21\u5177\u624d\u80fd\u751f\u6210\u8c03\u62e8\u5355!");
        }
        MouldAllot allot = new MouldAllot();
        Mould md = (Mould)moulds.get(0);
        BeanUtils.copyProperties((Object)md, (Object)allot);
        this.camplete(md, purCompany, purUser, allot);
        allot.setIds(ids);
        this.allotItemService.addToPrepure(allot);
        return allot;
    }

    private void camplete(Mould mould, Company purCompany, com.els.base.auth.entity.User purUser, MouldAllot allot) {
        allot.setProjectId(purCompany.getProjectId());
        allot.setSendStatus(Constant.NO_INT);
        allot.setAllotStatus(Constant.NO_INT);
        allot.setAllotNo(UUIDGenerator.generateUUID());
        allot.setAllotType(Constant.NO_INT);
        allot.setCreateTime(new Date());
        allot.setCreateUserName(purUser.getNickName());
    }

    @Override
    @CacheEvict(value={"mouldAllot"}, allEntries=true)
    public void deleteByAllotIds(List<String> ids, com.els.base.auth.entity.User user) {
        MouldAllotExample example = new MouldAllotExample();
        example.createCriteria().andIdIn((List)ids);
        List<MouldAllot> allots = this.mouldAllotMapper.selectByExample(example);
        for (MouldAllot mouldAllot : allots) {
            if (Constant.YES_INT.equals(mouldAllot.getSendStatus())) {
                throw new CommonException("\u5355\u636e\u5df2\u53d1\u9001\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            mouldAllot.setId(mouldAllot.getId());
            mouldAllot.setIsEnable(Constant.NO_INT);
            mouldAllot.setUpdateTime(new Date());
            mouldAllot.setUpdateUserName(user.getNickName());
            this.mouldAllotMapper.updateByPrimaryKeySelective(mouldAllot);
            AllotItemExample example2 = new AllotItemExample();
            example2.createCriteria().andAllotNoEqualTo(mouldAllot.getAllotNo());
            List items = this.allotItemService.queryAllObjByExample((IExample)example2);
            for (AllotItem allotItem : items) {
                MouldExample example3 = new MouldExample();
                example3.createCriteria().andMouldIdEqualTo(allotItem.getMouldId());
                List moulds = this.mouldService.queryAllObjByExample((IExample)example3);
                Assert.isNotEmpty((Collection)moulds, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5177");
                for (Mould mould : moulds) {
                    mould.setId(mould.getId());
                    mould.setMouldStatus(MouldStatus.USABLE.getCode());
                    this.mouldService.modifyObj(mould);
                }
            }
        }
    }

    @Override
    @CacheEvict(value={"mouldAllot"}, allEntries=true)
    public void abolishForPur(List<String> ids, final com.els.base.auth.entity.User user) {
        MouldAllotExample example = new MouldAllotExample();
        example.createCriteria().andIdIn((List)ids);
        List<MouldAllot> allots = this.mouldAllotMapper.selectByExample(example);
        for (MouldAllot mouldAllot : allots) {
            if (Constant.NO_INT.equals(mouldAllot.getSendStatus())) {
                throw new CommonException("\u5355\u636e:" + mouldAllot.getAllotNo() + "\u672a\u53d1\u9001,\u4e0d\u5141\u8bb8\u4f5c\u5e9f");
            }
            if (Constant.YES_INT.equals(mouldAllot.getAllotStatus())) {
                throw new CommonException("\u5355\u636e:" + mouldAllot.getAllotNo() + "\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u518d\u4f5c\u5e9f");
            }
            AllotItemExample example2 = new AllotItemExample();
            example2.createCriteria().andAllotNoEqualTo(mouldAllot.getAllotNo());
            List items = this.allotItemService.queryAllObjByExample((IExample)example2);
            Assert.isNotEmpty((Collection)items, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8c03\u62e8\u5355\u884c");
            for (AllotItem allotItem : items) {
                if (!Constant.YES_INT.equals(allotItem.getMouldConfirmStatus())) continue;
                throw new CommonException("\u8c03\u62e8\u5355\u53f7" + mouldAllot.getAllotNo() + "\u542b\u6709\u63a5\u6536\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4\u7684\u884c\u9879\u76ee,\u4e0d\u5141\u8bb8\u4f5c\u5e9f!");
            }
            mouldAllot.setId(mouldAllot.getId());
            mouldAllot.setAllotStatus(Constant.YES_INT);
            mouldAllot.setUpdateTime(new Date());
            mouldAllot.setUpdateUserName(user.getNickName());
            this.mouldAllotMapper.updateByPrimaryKeySelective(mouldAllot);
            for (AllotItem allotItem : items) {
                MouldExample example3 = new MouldExample();
                example3.createCriteria().andMouldIdEqualTo(allotItem.getMouldId());
                List moulds = this.mouldService.queryAllObjByExample((IExample)example3);
                Assert.isNotEmpty((Collection)moulds, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5177");
                for (Mould mould : moulds) {
                    mould.setId(mould.getId());
                    mould.setMouldStatus(MouldStatus.USABLE.getCode());
                    this.mouldService.modifyObj(mould);
                }
            }
        }
        List<MouldAllot> list = this.queryAllObjByExample(example);
        for (final MouldAllot allot : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    MouldAllotServiceImpl.this.sendMessagesToMouldSup(user, allot, MouldBusinessEnum.MOULD_ALLOT_ABOLISH.getCode());
                    MouldAllotServiceImpl.this.sendMessagesToConceiveSup(user, allot, MouldBusinessEnum.MOULD_ALLOT_ABOLISH.getCode());
                }
            });
        }
    }

    protected void sendMessagesToConceiveSup(com.els.base.auth.entity.User loginUser, MouldAllot data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getConceiveSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToMouldSup(com.els.base.auth.entity.User loginUser, MouldAllot data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getMouldSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @CacheEvict(value={"mouldAllot"}, allEntries=true)
    public void sendSup(List<String> ids, final com.els.base.auth.entity.User user) {
        MouldAllotExample example = new MouldAllotExample();
        example.createCriteria().andIdIn((List)ids);
        List<MouldAllot> allots = this.mouldAllotMapper.selectByExample(example);
        for (MouldAllot mouldAllot : allots) {
            if (Constant.YES_INT.equals(mouldAllot.getSendStatus())) {
                throw new CommonException("\u5355\u636e:" + mouldAllot.getAllotNo() + "\u5df2\u53d1\u9001,\u4e0d\u5141\u8bb8\u518d\u53d1\u9001");
            }
            mouldAllot.setId(mouldAllot.getId());
            mouldAllot.setSendStatus(Constant.YES_INT);
            mouldAllot.setUpdateTime(new Date());
            mouldAllot.setUpdateUserName(user.getNickName());
            mouldAllot.setSendTime(new Date());
            this.mouldAllotMapper.updateByPrimaryKeySelective(mouldAllot);
        }
        List<MouldAllot> list = this.queryAllObjByExample(example);
        for (final MouldAllot allot : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    MouldAllotServiceImpl.this.sendMessagesToMouldSup(user, allot, MouldBusinessEnum.MOULD_ALLOT_SEND.getCode());
                    MouldAllotServiceImpl.this.sendMessagesToConceiveSup(user, allot, MouldBusinessEnum.MOULD_ALLOT_SEND.getCode());
                }
            });
        }
    }
}

