/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.check.controller;

import com.els.base.auth.entity.User;
import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.mould.check.command.ConCheckResultCommand;
import com.els.base.mould.check.command.DeleteCheckCommand;
import com.els.base.mould.check.command.ModifyCommand;
import com.els.base.mould.check.command.SaveCheckResultCommand;
import com.els.base.mould.check.entity.Check;
import com.els.base.mould.check.entity.CheckExample;
import com.els.base.mould.check.entity.CheckItem;
import com.els.base.mould.check.entity.CheckItemExample;
import com.els.base.mould.check.service.CheckItemService;
import com.els.base.mould.check.service.CheckService;
import com.els.base.mould.check.utils.SendStatus;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.utils.ExcelFileData;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u76d8\u70b9\u901a\u77e5\u5355\u8868")
@Controller
@RequestMapping(value={"check"})
public class CheckController {
    @Resource
    protected CheckService checkService;
    @Resource
    protected MouldInvorker mouldInvorker;
    @Resource
    protected CheckItemService checkItemService;

    @ApiOperation(httpMethod="POST", value="\u751f\u6210\u76d8\u70b9\u901a\u77e5\u5355")
    @RequestMapping(value={"service/prepare"})
    @ResponseBody
    public ResponseResult<String> prepareForPur(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u6a21\u5177id\u4e0d\u80fd\u4e3a\u7a7a!");
        this.checkService.createCheckData(ids, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4fee\u6539\u76d8\u70b9\u901a\u77e5\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> cedit(@RequestBody Check check) {
        Assert.isNotNull((Object)check, (String)"\u76d8\u70b9\u901a\u77e5\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        ModifyCommand command = new ModifyCommand(check);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u76d8\u70b9\u901a\u77e5\u5355\u8868")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        DeleteCheckCommand command = new DeleteCheckCommand(ids);
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u65b9-\u67e5\u8be2\u76d8\u70b9\u901a\u77e5\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Check", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<Check>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CheckExample example = new CheckExample();
        example.setPageView((PageView<Check>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        CheckExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.checkService.queryObjByPage((IExample)example);
        List<Check> checks = this.getCheckItemList(pageData.getQueryResult());
        pageData.setQueryResult(checks);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546-\u67e5\u8be2\u76d8\u70b9\u901a\u77e5\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Check", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForSup"})
    @ResponseBody
    public ResponseResult<PageView<Check>> findByPageForSup(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        CheckExample example = new CheckExample();
        example.setPageView((PageView<Check>)new PageView(pageNo, pageSize));
        example.setOrderByClause("SEND_TIME DESC");
        CheckExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT).andSendStatusNotEqualTo(SendStatus.NOT_SEND.getCode()).andConceiveSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.checkService.queryObjByPage((IExample)example);
        List<Check> checks = this.getCheckItemList(pageData.getQueryResult());
        pageData.setQueryResult(checks);
        return ResponseResult.success((Object)pageData);
    }

    private List<Check> getCheckItemList(List<Check> list) {
        ArrayList<Check> checkList = new ArrayList<Check>();
        if (CollectionUtils.isEmpty(list)) {
            return checkList;
        }
        for (Check check : list) {
            List<CheckItem> item = this.checkItemService.queryByCheckId(check.getId());
            check.setCheckItem(item);
            checkList.add(check);
        }
        return checkList;
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u53d1\u9001\u76d8\u70b9\u901a\u77e5\u5355")
    @RequestMapping(value={"service/sendCheckForBatch"})
    @ResponseBody
    public ResponseResult<String> sendCheckForBatch(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u76d8\u70b9\u901a\u77e5\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        User loginUser = SpringSecurityUtils.getLoginUser();
        this.checkService.sendToSup(ids, loginUser);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u76d8\u70b9\u901a\u77e5\u5355\u6279\u91cf\u4f5c\u5e9f")
    @RequestMapping(value={"service/cancellationCheckForBatch"})
    @ResponseBody
    public ResponseResult<String> cancellationCheckForBatch(@RequestBody(required=true) List<String> checkIdList) {
        Assert.isNotEmpty(checkIdList, (String)"\u76d8\u70b9\u901a\u77e5\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        User loginUser = SpringSecurityUtils.getLoginUser();
        this.checkService.invalid(checkIdList, loginUser);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u786e\u8ba4-\u76d8\u70b9\u901a\u77e5\u5355")
    @RequestMapping(value={"service/confirmForConceiveSup"})
    @ResponseBody
    public ResponseResult<String> confirmForConceiveSup(@RequestBody(required=true) List<String> checkIdList) {
        Assert.isNotEmpty(checkIdList, (String)"\u76d8\u70b9\u901a\u77e5\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        User loginUser = SpringSecurityUtils.getLoginUser();
        Company purCompany = CompanyUtils.getPurCompanyOfCurrentCompany();
        this.checkService.confirmForConceiveSup(checkIdList, loginUser, purCompany);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4fdd\u5b58-\u5f55\u5165\u76d8\u70b9\u901a\u77e5\u5355\u7ed3\u679c")
    @RequestMapping(value={"service/saveCheckResult"})
    @ResponseBody
    public ResponseResult<String> saveCheckResult(@RequestBody Check check) {
        Assert.isNotNull((Object)check, (String)"\u76d8\u70b9\u901a\u77e5\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        SaveCheckResultCommand command = new SaveCheckResultCommand(check);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u53d1\u9001\u76d8\u70b9\u901a\u77e5\u5355\u7ed3\u679c")
    @RequestMapping(value={"service/sendCheckResultForBatch"})
    @ResponseBody
    public ResponseResult<String> sendCheckResultForBatch(@RequestBody(required=true) List<String> checkIdList) {
        Assert.isNotEmpty(checkIdList, (String)"\u76d8\u70b9\u901a\u77e5\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        User loginUser = SpringSecurityUtils.getLoginUser();
        this.checkService.sendToPurAndMould(checkIdList, loginUser);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u76d8\u70b9\u901a\u77e5\u5355\u7ed3\u679c-\u91c7\u8d2d\u65b9\u786e\u8ba4")
    @RequestMapping(value={"service/conCheckResult"})
    @ResponseBody
    public ResponseResult<String> conCheckResult(@RequestBody(required=true) List<String> ids) {
        Assert.isNotNull(ids, (String)"\u76d8\u70b9\u901a\u77e5\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        ConCheckResultCommand command = new ConCheckResultCommand(ids, SpringSecurityUtils.getLoginUser());
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser((com.els.base.core.entity.user.User)SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u51fa\u660e\u7ec6Excel", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcelForSup"})
    @ResponseBody
    public ResponseResult<FileData> exportForSupCompanyVerDownload(@RequestBody(required=true) String checkNo, String queryParams) throws Exception {
        CheckItemExample example = new CheckItemExample();
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
        }
        List items = null;
        example.createCriteria().andIsEnableEqualTo("N").andBillNoEqualTo(checkNo);
        items = this.checkItemService.queryAllObjByExample((IExample)example);
        Assert.isNotEmpty((Collection)items, (String)"\u5bfc\u51fa\u6570\u636e\u4e3a\u7a7a");
        for (CheckItem item : items) {
            if (item.getMouldStatus() == 0) {
                item.setMouldSupRemark("\u62a5\u5e9f");
            }
            if (item.getMouldStatus() == 1) {
                item.setMouldSupRemark("\u53ef\u7528");
            }
            if (item.getMouldStatus() == 2) {
                item.setMouldSupRemark("\u8fc1\u79fb\u4e2d");
            }
            if (item.getMouldStatus() == 3) {
                item.setMouldSupRemark("\u7ef4\u4fee\u4e2d");
            }
            if (item.getMouldStatus() == 4) {
                item.setMouldSupRemark("\u505c\u7528");
            }
            if (item.getMouldStatus() == 5) {
                item.setMouldSupRemark("\u76d8\u4e8f");
            }
            if (item.getUpdatStatus() == null) {
                item.setConceivSupRemark("");
            } else if (item.getUpdatStatus() == 0) {
                item.setConceivSupRemark("\u62a5\u5e9f");
            } else if (item.getUpdatStatus() == 1) {
                item.setConceivSupRemark("\u53ef\u7528");
            } else if (item.getUpdatStatus() == 2) {
                item.setConceivSupRemark("\u8fc1\u79fb\u4e2d");
            } else if (item.getUpdatStatus() == 3) {
                item.setConceivSupRemark("\u7ef4\u4fee\u4e2d");
            } else if (item.getUpdatStatus() == 4) {
                item.setConceivSupRemark("\u505c\u7528");
            } else {
                item.setConceivSupRemark("\u76d8\u4e8f");
            }
            if (item.getIsEnable().equals("N")) {
                item.setIsEnable("\u672a\u5220\u9664");
            }
            if (!item.getIsEnable().equals("Y")) continue;
            item.setIsEnable("\u5df2\u5220\u9664");
        }
        List<TitleAndModelKey> list = this.createExcelHeaderColumnDown((CheckItem)items.get(0));
        FileData fileData = ExcelFileData.createExcelFileOutputStream(list, items, "\u76d8\u70b9\u901a\u77e5\u5355\u660e\u7ec6", "\u76d8\u70b9\u901a\u77e5\u5355\u660e\u7ec6", 0);
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createExcelHeaderColumnDown(CheckItem checkItem) {
        ArrayList<TitleAndModelKey> item = new ArrayList<TitleAndModelKey>();
        item.add(ExcelUtils.createTitleAndModelKey((String)"\u884c\u53f7", (String)"itemNo"));
        item.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177ID", (String)"mouldId"));
        item.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u7f16\u53f7", (String)"mouldNo"));
        item.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u63cf\u8ff0", (String)"mouldDesc"));
        item.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u72b6\u6001", (String)"mouldSupRemark"));
        item.add(ExcelUtils.createTitleAndModelKey((String)"\u74f6\u578b", (String)"bottleType"));
        item.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u6750\u8d28", (String)"mouldQuality"));
        item.add(ExcelUtils.createTitleAndModelKey((String)"\u8154\u6570", (String)"cavityQuantity"));
        item.add(ExcelUtils.createTitleAndModelKey((String)"\u8bbe\u8ba1\u5bff\u547d", (String)"designedLifetime"));
        item.add(ExcelUtils.createTitleAndModelKey((String)"\u5220\u9664\u6807\u8bc6", (String)"isEnable"));
        item.add(ExcelUtils.createTitleAndModelKey((String)"\u5b9e\u9645\u4f7f\u7528\u5bff\u547d", (String)"usedLifetime"));
        item.add(ExcelUtils.createTitleAndModelKey((String)"\u72b6\u6001\u8c03\u6574", (String)"conceivSupRemark"));
        item.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"purRemark"));
        return item;
    }
}

