/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.scrap.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.utils.ExcelFileData;
import com.els.base.mould.scrap.command.ConfirmScrapCommand;
import com.els.base.mould.scrap.command.CreateScrapCommand;
import com.els.base.mould.scrap.command.DeleteScrapCommand;
import com.els.base.mould.scrap.command.ModifyCommand;
import com.els.base.mould.scrap.command.SaveFileCommand;
import com.els.base.mould.scrap.entity.Scrap;
import com.els.base.mould.scrap.entity.ScrapExample;
import com.els.base.mould.scrap.service.ScrapService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6a21\u5177\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
@Controller
@RequestMapping(value={"scrap"})
public class ScrapController {
    @Resource
    protected ScrapService scrapService;
    @Resource
    protected MouldInvorker mouldInvorker;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6a21\u5177\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        CreateScrapCommand command = new CreateScrapCommand(ids);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser((User)SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4fee\u6539\u6a21\u5177\u7ba1\u7406-\u62a5\u5e9f\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody Scrap scrap) {
        Assert.isNotNull((Object)scrap, (String)"\u62a5\u5e9f\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        ModifyCommand command = new ModifyCommand(scrap);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser((User)SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u53d1\u9001\u6a21\u5177\u7ba1\u7406-\u62a5\u5e9f\u5355")
    @RequestMapping(value={"service/sendScrapForBatch"})
    @ResponseBody
    public ResponseResult<String> sendScrapForBatch(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u5177\u62a5\u5e9f\u5355");
        com.els.base.auth.entity.User loginUser = SpringSecurityUtils.getLoginUser();
        this.scrapService.sendToSup(ids, loginUser);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u5220\u9664\u6a21\u5177\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
    @RequestMapping(value={"service/conDeleteByIds"})
    @ResponseBody
    public ResponseResult<String> conDeleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        DeleteScrapCommand command = new DeleteScrapCommand(ids);
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f9b\u5e94\u5546\u67e5\u8be2\u6a21\u5177\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Scrap", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/confindByPage"})
    @ResponseBody
    public ResponseResult<PageView<Scrap>> confindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ScrapExample example = new ScrapExample();
        example.setPageView((PageView<Scrap>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        ScrapExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo("N").andConceiveSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.scrapService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u67e5\u8be2\u6a21\u5177\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 Scrap", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/purfindByPage"})
    @ResponseBody
    public ResponseResult<PageView<Scrap>> purfindByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        ScrapExample example = new ScrapExample();
        example.setPageView((PageView<Scrap>)new PageView(pageNo, pageSize));
        example.setOrderByClause("SEND_TIME DESC");
        ScrapExample.Criteria criteria = example.createCriteria();
        criteria.andSendStatusEqualTo(Constant.YES_INT).andIsEnableEqualTo("N");
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.scrapService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u786e\u8ba4\u6a21\u5177\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
    @RequestMapping(value={"service/purConfirmScrapForBatch"})
    @ResponseBody
    public ResponseResult<String> purConfirmScrapForBatch(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        ConfirmScrapCommand command = new ConfirmScrapCommand(ids, SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u62a5\u5e9f\u5355\u2014\u786e\u8ba4\u5b8c\u6210\u4e0a\u4f20\u9644\u4ef6")
    @RequestMapping(value={"service/saveFile"})
    @ResponseBody
    public ResponseResult<String> saveFile(@RequestBody Scrap scrap) {
        Assert.isNotNull((Object)scrap, (String)"\u62a5\u5e9f\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        SaveFileCommand command = new SaveFileCommand(scrap);
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u9000\u56de\u6a21\u5177\u7ba1\u7406\u2014\u62a5\u5e9f\u5355")
    @RequestMapping(value={"service/rejectScrapForPur"})
    @ResponseBody
    public ResponseResult<String> rejectScrapForPur(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u62a5\u5e9f\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        com.els.base.auth.entity.User loginUser = SpringSecurityUtils.getLoginUser();
        this.scrapService.rejectForPur(ids, loginUser);
        return ResponseResult.success();
    }

    @ApiOperation(value="\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcelForPur"})
    @ResponseBody
    public ResponseResult<FileData> exportForPurCompanyVerDownload(@RequestBody(required=false) List<String> ids, String queryParams) throws Exception {
        ScrapExample example = new ScrapExample();
        example.setOrderByClause("CREATE_TIME DESC");
        ScrapExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo("N");
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
        }
        List scraps = null;
        if (CollectionUtils.isEmpty(ids)) {
            criteria.andSendStatusEqualTo(Constant.YES_INT);
            scraps = this.scrapService.queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)scraps, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a");
        } else {
            criteria.andIdIn((List)ids);
            scraps = this.scrapService.queryAllObjByExample((IExample)example);
        }
        for (Scrap scrap : scraps) {
            if (scrap.getMouldStatus() == 0) {
                scrap.setPurRemark("\u62a5\u5e9f");
            }
            if (scrap.getMouldStatus() == 1) {
                scrap.setPurRemark("\u53ef\u7528");
            }
            if (scrap.getMouldStatus() == 2) {
                scrap.setPurRemark("\u8fc1\u79fb\u4e2d");
            }
            if (scrap.getMouldStatus() == 3) {
                scrap.setPurRemark("\u7ef4\u4fee\u4e2d");
            }
            if (scrap.getMouldStatus() == 4) {
                scrap.setPurRemark("\u505c\u7528");
            }
            if (scrap.getMouldStatus() == 5) {
                scrap.setPurRemark("\u76d8\u4e8f");
            }
            if (scrap.getScrapMode() == 0) {
                scrap.setScrapType("\u81ea\u884c\u9500\u6bc1");
            }
            if (scrap.getScrapMode() != 1) continue;
            scrap.setScrapType("\u8fd4\u56de\u7acb\u767d");
        }
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumnDown();
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, scraps, "\u6a21\u5177\u62a5\u5e9f\u5355", "\u6a21\u5177\u62a5\u5e9f\u5355", 0);
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createExcelHeaderColumnDown() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u53f7", (String)"scrapNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u786e\u8ba4\u72b6\u6001", (String)"confirmStatus"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177ID", (String)"mouldId"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u7f16\u53f7", (String)"mouldNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u63cf\u8ff0", (String)"mouldDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u72b6\u6001", (String)"purRemark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6a21\u5177\u5e8f\u53f7", (String)"mouldNumber"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6536\u6a21\u65f6\u95f4", (String)"receiveMould"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u4ee3\u7801", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u540d\u79f0", (String)"companyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6301\u6709\u4f9b\u5e94\u5546SAP#", (String)"conceiveSupCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6301\u6709\u4f9b\u5e94\u5546\u540d\u79f0", (String)"conceiveSupCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8bbe\u8ba1\u5bff\u547d", (String)"designedLifetime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5df2\u4f7f\u7528\u5bff\u547d", (String)"usedLifetime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5269\u4f59\u5bff\u547d", (String)"surplusLifetime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u521b\u5efa\u65f6\u95f4", (String)"createTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62a5\u5e9f\u65b9\u5f0f", (String)"scrapType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u62a5\u5e9f\u65f6\u95f4", (String)"scrapTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9644\u4ef6", (String)"fileName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"conSupRemark"));
        return titleAndModelKeys;
    }
}

