/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.allot.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.file.entity.FileData;
import com.els.base.mould.allot.command.CreateCommand;
import com.els.base.mould.allot.command.ModifyCommand;
import com.els.base.mould.allot.entity.AllotItem;
import com.els.base.mould.allot.entity.AllotItemExample;
import com.els.base.mould.allot.entity.MouldAllot;
import com.els.base.mould.allot.entity.MouldAllotExample;
import com.els.base.mould.allot.service.AllotItemService;
import com.els.base.mould.allot.service.MouldAllotService;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.master.utils.ExcelFileData;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.json.JsonUtils;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u6a21\u5177\u7ba1\u7406-\u8c03\u62e8\u5355")
@Controller
@RequestMapping(value={"mouldAllot"})
public class MouldAllotController {
    @Resource
    protected MouldAllotService mouldAllotService;
    @Resource
    protected MouldInvorker mouldInvorker;
    @Resource
    protected MouldService mouldService;
    @Resource
    protected AllotItemService allotItemService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6a21\u5177\u7ba1\u7406-\u8c03\u62e8\u5355\u9884\u89c8\u6570\u636e")
    @RequestMapping(value={"service/prepare"})
    @ResponseBody
    public ResponseResult<MouldAllot> prepareForPur(@RequestBody List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u6a21\u5177id\u4e0d\u80fd\u4e3a\u7a7a!");
        MouldAllot allot = this.mouldAllotService.prepareForPur(ids, CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser());
        return ResponseResult.success((Object)allot);
    }

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u6a21\u5177\u7ba1\u7406-\u8c03\u62e8\u5355")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody MouldAllot allot) {
        Assert.isNotNull((Object)allot, (String)"\u8c03\u62e8\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        CreateCommand command = new CreateCommand(allot);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser(SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4fee\u6539\u6a21\u5177\u7ba1\u7406-\u8c03\u62e8\u5355")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody MouldAllot allot) {
        Assert.isNotNull((Object)allot, (String)"\u8c03\u62e8\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        ModifyCommand command = new ModifyCommand(allot);
        command.setPurCompany(CompanyUtils.currentCompany());
        command.setPurUser(SpringSecurityUtils.getLoginUser());
        this.mouldInvorker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4f5c\u5e9f\u6a21\u5177\u7ba1\u7406-\u8c03\u62e8\u5355")
    @RequestMapping(value={"service/abolish"})
    @ResponseBody
    public ResponseResult<String> abolish(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u4f5c\u5e9f\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.mouldAllotService.abolishForPur(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u6a21\u5177\u7ba1\u7406-\u8c03\u62e8\u5355")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.mouldAllotService.deleteByAllotIds(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u6a21\u5177\u7ba1\u7406-\u8c03\u62e8\u5355")
    @RequestMapping(value={"service/sendToSup"})
    @ResponseBody
    public ResponseResult<String> sendToSup(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u53d1\u9001\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        this.mouldAllotService.sendSup(ids, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u91c7\u8d2d\u5546\u67e5\u8be2\u6a21\u5177\u7ba1\u7406-\u8c03\u62e8\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MouldAllot", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForPur"})
    @ResponseBody
    public ResponseResult<PageView<MouldAllot>> findByPageForPur(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String mouldDesc, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldAllotExample example = new MouldAllotExample();
        example.setPageView((PageView<MouldAllot>)new PageView(pageNo, pageSize));
        example.setOrderByClause("CREATE_TIME DESC");
        if (StringUtils.isNotBlank((String)mouldDesc)) {
            List<AllotItem> itemList = this.queryItemByDesc(mouldDesc);
            if (CollectionUtils.isEmpty(itemList)) {
                return ResponseResult.success((Object)new PageView(pageNo, pageSize));
            }
            this.setExample(itemList, example, null, null);
        } else {
            example.createCriteria().andIsEnableEqualTo(Constant.YES_INT);
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.mouldAllotService.queryObjByPage((IExample)example);
        this.setAllotList(pageData.getQueryResult());
        return ResponseResult.success((Object)pageData);
    }

    private List<AllotItem> queryItemByDesc(String mouldDesc) {
        AllotItemExample example = new AllotItemExample();
        example.createCriteria().andMouldDescLike("%" + mouldDesc + "%");
        return this.allotItemService.queryAllObjByExample((IExample)example);
    }

    private void setAllotList(List<MouldAllot> allots) {
        if (CollectionUtils.isEmpty(allots)) {
            return;
        }
        List allotNoList = allots.stream().map(MouldAllot::getAllotNo).distinct().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        AllotItemExample itemExample = new AllotItemExample();
        itemExample.createCriteria().andAllotNoIn(allotNoList);
        List allotItemList = this.allotItemService.queryAllObjByExample((IExample)itemExample);
        if (CollectionUtils.isEmpty((Collection)allotItemList)) {
            return;
        }
        Map<String, List<AllotItem>> group = allotItemList.stream().collect(Collectors.groupingBy(AllotItem::getAllotNo));
        for (MouldAllot mouldAllot : allots) {
            mouldAllot.setItems(group.get(mouldAllot.getAllotNo()));
        }
    }

    @ApiOperation(httpMethod="POST", value="\u63a5\u6536\u4f9b\u5e94\u5546\u67e5\u8be2\u6a21\u5177\u7ba1\u7406-\u8c03\u62e8\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MouldAllot", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForMou"})
    @ResponseBody
    public ResponseResult<PageView<MouldAllot>> findByPageForMou(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String mouldDesc, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldAllotExample example = new MouldAllotExample();
        example.setPageView((PageView<MouldAllot>)new PageView(pageNo, pageSize));
        example.setOrderByClause("SEND_TIME DESC");
        if (StringUtils.isNotBlank((String)mouldDesc)) {
            List<AllotItem> itemList = this.queryItemByDesc(mouldDesc);
            if (CollectionUtils.isEmpty(itemList)) {
                return ResponseResult.success((Object)new PageView(pageNo, pageSize));
            }
            this.setExample(itemList, example, CompanyUtils.currentCompany().getId(), null);
        } else {
            example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andMouldSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId()).andSendStatusEqualTo(Constant.YES_INT);
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.mouldAllotService.queryObjByPage((IExample)example);
        this.setAllotList(pageData.getQueryResult());
        return ResponseResult.success((Object)pageData);
    }

    private void setExample(List<AllotItem> itemList, MouldAllotExample example, String mouldSupCompanyId, String conceiveSupCompanyId) {
        List allotNoList = itemList.stream().map(AllotItem::getAllotNo).distinct().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        List group = Lists.partition(allotNoList, (int)999);
        for (List list : group) {
            MouldAllotExample.Criteria cri = example.or().andAllotNoIn(list).andIsEnableEqualTo(Constant.YES_INT);
            if (StringUtils.isNotBlank((String)mouldSupCompanyId)) {
                cri.andMouldSupCompanyIdEqualTo(mouldSupCompanyId).andSendStatusEqualTo(Constant.YES_INT);
            }
            if (!StringUtils.isNotBlank((String)conceiveSupCompanyId)) continue;
            cri.andConceiveSupCompanyIdEqualTo(conceiveSupCompanyId).andSendStatusEqualTo(Constant.YES_INT);
        }
    }

    @ApiOperation(httpMethod="POST", value="\u8c03\u51fa\u4f9b\u5e94\u5546\u67e5\u8be2\u6a21\u5177\u7ba1\u7406-\u8c03\u62e8\u5355")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 MouldAllot", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPageForCon"})
    @ResponseBody
    public ResponseResult<PageView<MouldAllot>> findByPageForCon(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String mouldDesc, @RequestBody(required=false) QueryParamWapper wapper) {
        MouldAllotExample example = new MouldAllotExample();
        example.setPageView((PageView<MouldAllot>)new PageView(pageNo, pageSize));
        example.setOrderByClause("SEND_TIME DESC");
        if (StringUtils.isNotBlank((String)mouldDesc)) {
            List<AllotItem> itemList = this.queryItemByDesc(mouldDesc);
            if (CollectionUtils.isEmpty(itemList)) {
                return ResponseResult.success((Object)new PageView(pageNo, pageSize));
            }
            this.setExample(itemList, example, null, CompanyUtils.currentCompany().getId());
        } else {
            example.createCriteria().andIsEnableEqualTo(Constant.YES_INT).andConceiveSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId()).andSendStatusEqualTo(Constant.YES_INT);
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.mouldAllotService.queryObjByPage((IExample)example);
        this.setAllotList(pageData.getQueryResult());
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(value="\u5bfc\u51faExcel", httpMethod="POST")
    @RequestMapping(value={"service/downloadExcelForPur"})
    @ResponseBody
    public ResponseResult<FileData> exportForPurCompanyVerDownload(@RequestBody(required=false) List<String> ids, String queryParams) throws Exception {
        MouldAllotExample example = new MouldAllotExample();
        example.setOrderByClause("CREATE_TIME DESC");
        MouldAllotExample.Criteria criteria = example.createCriteria();
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (StringUtils.isNotEmpty((String)queryParams)) {
            QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtils.convertValue((String)queryParams, QueryParamWapper.class);
            CriteriaUtils.addCriterion((Object)criteria, (QueryParamWapper)queryParamWapper);
        }
        List allots = null;
        if (CollectionUtils.isEmpty(ids)) {
            allots = this.mouldAllotService.queryAllObjByExample((IExample)example);
            Assert.isNotEmpty((Collection)allots, (String)"\u5bfc\u51fa\u7684\u6570\u636e\u4e3a\u7a7a");
        } else {
            criteria.andIdIn((List)ids);
            allots = this.mouldAllotService.queryAllObjByExample((IExample)example);
        }
        for (MouldAllot allot : allots) {
            if (allot.getAllotStatus() == 0) {
                allot.setMouldSupRemark("\u65b0\u5efa");
            }
            if (allot.getAllotStatus() == 1) {
                allot.setMouldSupRemark("\u4f5c\u5e9f");
            }
            if (allot.getSendStatus() == 0) {
                allot.setConceiveSupRemark("\u672a\u53d1\u9001");
            }
            if (allot.getSendStatus() != 0) continue;
            allot.setConceiveSupRemark("\u5df2\u53d1\u9001");
        }
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumnDown((MouldAllot)allots.get(0));
        FileData fileData = ExcelFileData.createExcelFileOutputStream(titleAndModelKeys, allots, "\u6a21\u5177\u8c03\u62e8\u5355", "\u6a21\u5177\u8c03\u62e8\u5355", 0);
        return ResponseResult.success((Object)fileData);
    }

    private List<TitleAndModelKey> createExcelHeaderColumnDown(MouldAllot allot) {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u53d1\u9001\u72b6\u6001", (String)"conceiveSupRemark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"mouldSupRemark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8c03\u62e8\u5355\u53f7", (String)"allotNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u4ee3\u7801", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u516c\u53f8\u540d\u79f0", (String)"companyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8c03\u51fa\u4f9b\u5e94\u5546SAP#", (String)"conceiveSupCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8c03\u51fa\u4f9b\u5e94\u5546\u540d\u79f0", (String)"conceiveSupCompanyFullName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u63a5\u6536\u4f9b\u5e94\u5546SAP#", (String)"mouldSupCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u63a5\u6536\u4f9b\u5e94\u5546\u540d\u79f0", (String)"mouldSupCompanyFullName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u521b\u5efa\u65f6\u95f4", (String)"createTime"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"purRemark"));
        return titleAndModelKeys;
    }
}

