/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.life.command;

import com.els.base.mould.life.command.AbstractCommand;
import com.els.base.mould.life.command.LifeComandInvoker;
import com.els.base.mould.life.sap.TABLEOFZSRMRFCSHSL;
import com.els.base.mould.life.sap.ZSRMRFCSHSLResponse;
import com.els.base.mould.life.service.impl.LifeSapServiceImpl;
import com.els.base.mould.life.utils.SapConfUtils;
import com.els.base.mould.life.utils.SapException;
import com.els.base.mould.life.utils.SoapServiceRequestText;
import com.qqt.service.vo.HttpCallbackResultVO;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSapInfoCommand
extends AbstractCommand<TABLEOFZSRMRFCSHSL> {
    private static Logger log = LoggerFactory.getLogger(LifeSapServiceImpl.class);
    private static String username = SapConfUtils.getServiceUsername();
    private static String password = SapConfUtils.getServicePassword();
    private static String serviceUrl = SapConfUtils.getDeductionUrl();
    private static String serviceNameSpace = SapConfUtils.getDeductionNameSpace();
    private static String serviceMethod = SapConfUtils.getDeductionServiceMethod();
    private String materialNo;
    private String sapCode;
    private String startTime;
    private String endTime;

    public GetSapInfoCommand(String materialNo, String sapCode, String startTime, String endTime) {
        this.materialNo = materialNo;
        this.sapCode = sapCode;
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @Override
    public TABLEOFZSRMRFCSHSL execute(LifeComandInvoker context) {
        log.debug("\u3010\u6536\u8d27\u68c0\u67e5sap\u63a5\u53e3\u83b7\u53d6\u3011serviceUrl\u4e3a[{}]", (Object)serviceUrl);
        SoapServiceRequestText request = new SoapServiceRequestText();
        request.setUrl(serviceUrl);
        if (StringUtils.isNotBlank((String)serviceNameSpace)) {
            request.setNamespace(serviceNameSpace);
        }
        if (!StringUtils.isEmpty((String)username)) {
            String src = username.trim() + ":" + password.trim();
            String encoding = new String(Base64.encodeBase64((byte[])src.getBytes()));
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Basic " + encoding);
            request.addHeaders(headers);
        }
        request.setMethodName(serviceMethod);
        String xmlParams = this.getXmlParams(this.materialNo, this.sapCode, this.startTime, this.endTime);
        request.setXmlParams(xmlParams);
        log.debug("\u3010\u6536\u8d27\u68c0\u67e5sap\u63a5\u53e3\u83b7\u53d6\u3011\u8bf7\u6c42\u53c2\u6570\u4e3a[{}]", (Object)xmlParams);
        log.debug("\u3010\u6536\u8d27\u68c0\u67e5sap\u63a5\u53e3\u83b7\u53d6\u3011\u5f00\u59cb\u8c03\u7528sap\u63a5\u53e3");
        long startTime = System.currentTimeMillis();
        HttpCallbackResultVO vo = request.execute(ZSRMRFCSHSLResponse.class);
        long endTime = System.currentTimeMillis();
        log.debug("\u3010\u6536\u8d27\u68c0\u67e5sap\u63a5\u53e3\u83b7\u53d6\u3011\u7ed3\u675f\u8c03\u7528sap\u63a5\u53e3,\u7528\u65f6\u4e3a[{}]", (Object)(endTime - startTime));
        if (vo.getStatus() < 200 || vo.getStatus() > 299) {
            log.error("--> http status {}", (Object)vo.getStatus());
            log.error("--> ReasonPhrase {}", (Object)vo.getReasonPhrase());
            log.error("--> error {}", (Object)vo.getError());
            throw new SapException("500 SAP Internal Server Error");
        }
        log.debug("\u3010\u6536\u8d27\u68c0\u67e5sap\u63a5\u53e3\u83b7\u53d6\u3011\u8fd4\u56de\u7ed3\u679c\u4e3a", vo.getResult());
        ZSRMRFCSHSLResponse respone = (ZSRMRFCSHSLResponse)vo.getResult();
        if (respone == null) {
            throw new SapException("\u6536\u8d27\u68c0\u67e5sap\u63a5\u53e3\u83b7\u53d6,\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
        }
        TABLEOFZSRMRFCSHSL outData = respone.getETDATAS();
        log.info("\u3010\u6536\u8d27\u68c0\u67e5sap\u63a5\u53e3\u83b7\u53d6\u30111\u3001\u4ecesap\u83b7\u53d6\u6570\u636e[{}]\u6761", (Object)outData.getItem().size());
        return outData;
    }

    private String getXmlParams(String materialNo, String sapCode, String startTime, String endTime) {
        StringBuffer sbBuffer = new StringBuffer();
        sbBuffer.append("<ET_DATAS>");
        sbBuffer.append("</ET_DATAS>");
        sbBuffer.append("<IR_BUDAT>");
        sbBuffer.append("<item>");
        sbBuffer.append("<SIGN>I</SIGN>");
        sbBuffer.append("<OPTION>BT</OPTION>");
        sbBuffer.append("<LOW>" + startTime + "</LOW>");
        sbBuffer.append("<HIGH>" + endTime + "</HIGH>");
        sbBuffer.append("</item>");
        sbBuffer.append("</IR_BUDAT>");
        sbBuffer.append("<IR_LIFNR>");
        sbBuffer.append("<item>");
        sbBuffer.append("<SIGN>I</SIGN>");
        sbBuffer.append("<OPTION>EQ</OPTION>");
        sbBuffer.append("<LOW>" + sapCode + "</LOW>");
        sbBuffer.append("<HIGH></HIGH>");
        sbBuffer.append("</item>");
        sbBuffer.append("</IR_LIFNR>");
        sbBuffer.append("<IR_MATNR>");
        sbBuffer.append("<item>");
        sbBuffer.append("<SIGN>I</SIGN>");
        sbBuffer.append("<OPTION>EQ</OPTION>");
        String pattern = "000000000000000000";
        sbBuffer.append("<LOW>" + pattern.substring(0, pattern.length() - materialNo.length()) + materialNo + "</LOW>");
        sbBuffer.append("<HIGH></HIGH>");
        sbBuffer.append("</item>");
        sbBuffer.append("</IR_MATNR>");
        return sbBuffer.toString();
    }
}

