/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.notice.service.impl;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.notice.dao.NoticeFormFileMapper;
import com.els.base.mould.notice.entity.MouldNotice;
import com.els.base.mould.notice.entity.MouldNoticeExample;
import com.els.base.mould.notice.entity.NoticeFormFile;
import com.els.base.mould.notice.entity.NoticeFormFileExample;
import com.els.base.mould.notice.service.MouldNoticeService;
import com.els.base.mould.notice.service.NoticeFormFileService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultNoticeFormFileService")
public class NoticeFormFileServiceImpl
implements NoticeFormFileService {
    @Resource
    protected NoticeFormFileMapper noticeFormFileMapper;
    @Resource
    protected MouldNoticeService mouldNoticeService;

    @CacheEvict(value={"noticeFormFile"}, allEntries=true)
    public void addObj(NoticeFormFile t) {
        this.noticeFormFileMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"noticeFormFile"}, allEntries=true)
    public void addAll(List<NoticeFormFile> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.noticeFormFileMapper.insertBatch(list);
    }

    @CacheEvict(value={"noticeFormFile"}, allEntries=true)
    public void deleteObjById(String id) {
        this.noticeFormFileMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"noticeFormFile"}, allEntries=true)
    public void deleteByExample(NoticeFormFileExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.noticeFormFileMapper.deleteByExample(example);
    }

    @CacheEvict(value={"noticeFormFile"}, allEntries=true)
    public void modifyObj(NoticeFormFile t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.noticeFormFileMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"noticeFormFile"}, keyGenerator="redisKeyGenerator")
    public NoticeFormFile queryObjById(String id) {
        return this.noticeFormFileMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"noticeFormFile"}, keyGenerator="redisKeyGenerator")
    public List<NoticeFormFile> queryAllObjByExample(NoticeFormFileExample example) {
        return this.noticeFormFileMapper.selectByExample(example);
    }

    @Cacheable(value={"noticeFormFile"}, keyGenerator="redisKeyGenerator")
    public PageView<NoticeFormFile> queryObjByPage(NoticeFormFileExample example) {
        PageView<NoticeFormFile> pageView = example.getPageView();
        pageView.setQueryResult(this.noticeFormFileMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"noticeFormFile"}, keyGenerator="redisKeyGenerator")
    public List<NoticeFormFile> queryByNoticeItemNo(String itemNo) {
        Assert.isNotBlank((String)itemNo, (String)"\u884c\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        NoticeFormFileExample example = new NoticeFormFileExample();
        example.createCriteria().andNoticeItemNoEqualTo(itemNo).andIsEnableEqualTo(Constant.YES_INT);
        return this.noticeFormFileMapper.selectByExample(example);
    }

    @Override
    @CacheEvict(value={"noticeFormFile"}, allEntries=true)
    public void updateByExampleSelective(NoticeFormFile file, NoticeFormFileExample example) {
        this.noticeFormFileMapper.updateByExample(file, example);
    }

    @Override
    @CacheEvict(value={"noticeFormFile"}, allEntries=true)
    public void deleteObjByIds(List<String> ids) {
        NoticeFormFileExample example = new NoticeFormFileExample();
        example.createCriteria().andIdIn((List)ids);
        List<NoticeFormFile> files = this.noticeFormFileMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(files)) {
            MouldNoticeExample example2 = new MouldNoticeExample();
            example2.createCriteria().andNoticeNoEqualTo(files.get(0).getNoticeNo());
            List notices = this.mouldNoticeService.queryAllObjByExample((IExample)example2);
            Assert.isNotEmpty((Collection)notices, (String)"\u672a\u627e\u5230\u8be5\u901a\u77e5\u5355");
            if (Constant.YES_INT.equals(((MouldNotice)notices.get(0)).getSendStatus())) {
                throw new CommonException("\u8be5\u901a\u77e5\u5355\u5df2\u53d1\u9001,\u4e0d\u5141\u8bb8\u518d\u5220\u9664");
            }
        }
        for (NoticeFormFile file : files) {
            file.setId(file.getId());
            file.setIsEnable(Constant.NO_INT);
            this.noticeFormFileMapper.updateByPrimaryKeySelective(file);
        }
    }
}

