/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.notice.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.master.entity.Mould;
import com.els.base.mould.master.entity.MouldExample;
import com.els.base.mould.master.service.MouldService;
import com.els.base.mould.master.utils.MouldStatus;
import com.els.base.mould.notice.dao.NoticeItemMapper;
import com.els.base.mould.notice.entity.MouldNotice;
import com.els.base.mould.notice.entity.MouldNoticeExample;
import com.els.base.mould.notice.entity.NoticeItem;
import com.els.base.mould.notice.entity.NoticeItemExample;
import com.els.base.mould.notice.service.MouldNoticeService;
import com.els.base.mould.notice.service.NoticeItemService;
import com.els.base.mould.notice.utils.BillStatus;
import com.els.base.mould.notice.utils.ConfirmStatus;
import com.els.base.mould.utils.MouldBusinessEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultNoticeItemService")
public class NoticeItemServiceImpl
implements NoticeItemService {
    @Resource
    protected NoticeItemMapper noticeItemMapper;
    @Resource
    protected MouldNoticeService mouldNoticeService;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private MouldService mouldService;
    @Resource
    private CompanyService companyService;

    @CacheEvict(value={"noticeItem"}, allEntries=true)
    public void addObj(NoticeItem t) {
        this.noticeItemMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"noticeItem"}, allEntries=true)
    public void addAll(List<NoticeItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.noticeItemMapper.insertBatch(list);
    }

    @CacheEvict(value={"noticeItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.noticeItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"noticeItem"}, allEntries=true)
    public void deleteByExample(NoticeItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.noticeItemMapper.deleteByExample(example);
    }

    @CacheEvict(value={"noticeItem"}, allEntries=true)
    public void modifyObj(NoticeItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.noticeItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"noticeItem"}, keyGenerator="redisKeyGenerator")
    public NoticeItem queryObjById(String id) {
        return this.noticeItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"noticeItem"}, keyGenerator="redisKeyGenerator")
    public List<NoticeItem> queryAllObjByExample(NoticeItemExample example) {
        return this.noticeItemMapper.selectByExample(example);
    }

    @Cacheable(value={"noticeItem"}, keyGenerator="redisKeyGenerator")
    public PageView<NoticeItem> queryObjByPage(NoticeItemExample example) {
        PageView<NoticeItem> pageView = example.getPageView();
        pageView.setQueryResult(this.noticeItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"noticeItem"}, keyGenerator="redisKeyGenerator")
    public int countByExample(NoticeItemExample example) {
        return this.noticeItemMapper.countByExample(example);
    }

    @Override
    @Cacheable(value={"noticeItem"}, keyGenerator="redisKeyGenerator")
    public List<NoticeItem> queryByNoticeId(String id) {
        Assert.isNotBlank((String)id, (String)"\u901a\u77e5\u5355\u5173\u8054id\u4e0d\u80fd\u4e3a\u7a7a");
        NoticeItemExample example = new NoticeItemExample();
        example.createCriteria().andNoticeIdEqualTo(id).andIsEnableEqualTo("N");
        return this.noticeItemMapper.selectByExample(example);
    }

    @Override
    @CacheEvict(value={"noticeItem"}, allEntries=true)
    public void updateByExampleSelective(NoticeItem item, NoticeItemExample example) {
        this.updateByExampleSelective(item, example);
    }

    @Override
    @Transactional
    @CacheEvict(value={"noticeItem"}, allEntries=true)
    public void insert(NoticeItem noticeItem) {
        MouldNoticeExample example2 = new MouldNoticeExample();
        example2.createCriteria().andNoticeNoEqualTo(noticeItem.getNoticeNo());
        List notices = this.mouldNoticeService.queryAllObjByExample((IExample)example2);
        Assert.isNotEmpty((Collection)notices, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5f00\u6a21\u901a\u77e5\u5355");
        if (Constant.YES_INT.equals(((MouldNotice)notices.get(0)).getSendStatus())) {
            throw new CommonException("\u8be5\u901a\u77e5\u5355\u5df2\u53d1\u9001,\u4e0d\u5141\u8bb8\u5728\u6dfb\u52a0");
        }
        noticeItem.setId(UUIDGenerator.generateUUID());
        noticeItem.setItemNo(UUIDGenerator.generateUUID());
        noticeItem.setConfirmStatus(ConfirmStatus.NO_CONFIRM.getCode());
        String mouldNo = noticeItem.getMouldNo();
        MouldExample example = new MouldExample();
        example.createCriteria().andMouldIdLike(mouldNo + "___");
        int i = this.mouldService.countByExample(example);
        NoticeItemExample example3 = new NoticeItemExample();
        example3.createCriteria().andMouldIdLike(mouldNo + "___");
        int j = this.noticeItemMapper.countByExample(example3);
        String id = String.format("%s%03d", mouldNo, i + j + 1);
        noticeItem.setMouldId(id);
        noticeItem.setIsEnable("N");
        this.addObj(noticeItem);
    }

    @Override
    @Transactional
    @CacheEvict(value={"noticeItem"}, allEntries=true)
    public void confirmForMouldSup(List<String> ids, final User loginUser) {
        NoticeItemExample example = new NoticeItemExample();
        example.createCriteria().andIdIn((List)ids);
        List<NoticeItem> items = this.noticeItemMapper.selectByExample(example);
        Assert.isNotEmpty(items, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355\u884c\u9879");
        MouldNoticeExample example2 = new MouldNoticeExample();
        example2.createCriteria().andIdEqualTo(items.get(0).getNoticeId());
        List notices = this.mouldNoticeService.queryAllObjByExample((IExample)example2);
        Assert.isNotEmpty((Collection)notices, (String)"\u672a\u627e\u5230\u5bf9\u7528\u7684\u901a\u77e5\u5355");
        MouldNotice mouldNotice = (MouldNotice)notices.get(0);
        if (BillStatus.ABOLISH.getCode().equals(mouldNotice.getBillStatus())) {
            throw new CommonException("\u901a\u77e5\u5355:" + mouldNotice.getNoticeNo() + "\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4!");
        }
        for (NoticeItem item : items) {
            if (item.getConfirmStatus().equals(ConfirmStatus.CONCEIVE_SUP_CONFIRM.getCode())) {
                throw new CommonException("\u884c\u53f7:" + item.getItemNo() + "\u63a5\u6536\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4!");
            }
            if (item.getConfirmStatus().equals(ConfirmStatus.MOULD_SUP_CONFIRM.getCode())) {
                throw new CommonException("\u884c\u53f7:" + item.getItemNo() + "\u6a21\u5177\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4!");
            }
            item.setId(item.getId());
            item.setConfirmStatus(ConfirmStatus.MOULD_SUP_CONFIRM.getCode());
            if (item.getConfirmTime() == null) {
                item.setConfirmTime(new Date());
            }
            this.noticeItemMapper.updateByPrimaryKeySelective(item);
        }
        example.clear();
        example.createCriteria().andNoticeIdEqualTo(mouldNotice.getId());
        List<NoticeItem> list2 = this.noticeItemMapper.selectByExample(example);
        Set collect = list2.stream().map(i -> i.getConfirmStatus()).collect(Collectors.toSet());
        if (collect.size() == 1) {
            mouldNotice.setBillStatus(BillStatus.BUILD_MOULDING.getCode());
        } else {
            mouldNotice.setBillStatus(BillStatus.PART_BUILD_MOULDING.getCode());
        }
        this.mouldNoticeService.modifyObj(mouldNotice);
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        List<NoticeItem> list = this.queryAllObjByExample(example);
        for (final NoticeItem noticeItem : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    NoticeItemServiceImpl.this.sendMessagesToPur(loginUser, noticeItem, MouldBusinessEnum.MOULD_NOTICE_MOU_CONFIRM.getCode());
                    NoticeItemServiceImpl.this.sendMessagesToConceiveSup(loginUser, noticeItem, MouldBusinessEnum.MOULD_NOTICE_MOU_CONFIRM.getCode());
                }
            });
        }
    }

    protected void sendMessagesToPur(User loginUser, NoticeItem data, String businessType) {
        User purUser = this.companyUserRefService.queryMainUserOfCompany(data.getPurCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(purUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToConceiveSup(User loginUser, NoticeItem data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getConceiveSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToMouldSup(User loginUser, NoticeItem data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getMouldSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    @Override
    @Transactional
    @CacheEvict(value={"noticeItem"}, allEntries=true)
    public void confirmForConSup(List<String> ids, final User loginUser) {
        NoticeItemExample example = new NoticeItemExample();
        example.createCriteria().andIdIn((List)ids);
        List<NoticeItem> items = this.noticeItemMapper.selectByExample(example);
        Assert.isNotEmpty(items, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u901a\u77e5\u5355\u884c\u9879");
        MouldNoticeExample example2 = new MouldNoticeExample();
        example2.createCriteria().andIdEqualTo(items.get(0).getNoticeId());
        List notices = this.mouldNoticeService.queryAllObjByExample((IExample)example2);
        Assert.isNotEmpty((Collection)notices, (String)"\u672a\u627e\u5230\u5bf9\u7528\u7684\u901a\u77e5\u5355");
        MouldNotice mouldNotice = (MouldNotice)notices.get(0);
        if (BillStatus.ABOLISH.getCode().equals(mouldNotice.getBillStatus())) {
            throw new CommonException("\u901a\u77e5\u5355:" + mouldNotice.getNoticeNo() + "\u5df2\u4f5c\u5e9f,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4!");
        }
        for (NoticeItem item : items) {
            if (item.getConfirmStatus().equals(ConfirmStatus.CONCEIVE_SUP_CONFIRM.getCode())) {
                throw new CommonException("\u884c\u53f7:" + item.getItemNo() + "\u63a5\u6536\u4f9b\u5e94\u5546\u5df2\u786e\u8ba4,\u4e0d\u5141\u8bb8\u518d\u786e\u8ba4!");
            }
            item.setId(item.getId());
            item.setConfirmStatus(ConfirmStatus.CONCEIVE_SUP_CONFIRM.getCode());
            if (item.getReceiveMouldDate() == null) {
                item.setReceiveMouldDate(new Date());
            }
            this.noticeItemMapper.updateByPrimaryKeySelective(item);
        }
        example.clear();
        example.createCriteria().andNoticeIdEqualTo(mouldNotice.getId());
        List<NoticeItem> list2 = this.noticeItemMapper.selectByExample(example);
        Set collect = list2.stream().map(i -> i.getConfirmStatus()).collect(Collectors.toSet());
        if (collect.size() == 1) {
            mouldNotice.setBillStatus(BillStatus.MOULD_SETTLEMENT.getCode());
        } else {
            mouldNotice.setBillStatus(BillStatus.PART_MOULD_SETTLEMENT.getCode());
        }
        this.mouldNoticeService.modifyObj(mouldNotice);
        this.addMould(mouldNotice, items, loginUser);
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        List<NoticeItem> list = this.queryAllObjByExample(example);
        for (final NoticeItem noticeItem : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    NoticeItemServiceImpl.this.sendMessagesToPur(loginUser, noticeItem, MouldBusinessEnum.MOULD_NOTICE_CON_CONFIRM.getCode());
                    NoticeItemServiceImpl.this.sendMessagesToMouldSup(loginUser, noticeItem, MouldBusinessEnum.MOULD_NOTICE_CON_CONFIRM.getCode());
                }
            });
        }
    }

    private void addMould(MouldNotice mouldNotice, List<NoticeItem> items, User loginUser) {
        for (NoticeItem noticeItem : items) {
            Mould mould = new Mould();
            BeanUtils.copyProperties((Object)noticeItem, (Object)mould);
            mould.setCreateTime(new Date());
            mould.setCreateUserName(loginUser.getNickName());
            mould.setIsAllot(Constant.NO_INT);
            mould.setIsEnable(Constant.YES_INT);
            mould.setMouldStatus(MouldStatus.USABLE.getCode());
            mould.setNoticeItemId(noticeItem.getId());
            mould.setApplyTime(mouldNotice.getApplyTime());
            mould.setApplyUserName(mouldNotice.getCreateUserName());
            mould.setCompanyCode(mouldNotice.getCompanyCode());
            mould.setCompanyName(mouldNotice.getCompanyName());
            mould.setBottleType(noticeItem.getSuitBottle());
            mould.setBottleDesc(noticeItem.getSuitBottleDesc());
            mould.setSupplyArea(noticeItem.getFactory());
            this.completeinfo(mouldNotice, noticeItem, mould);
            mould.setTimeUnit("\u79d2");
            mould.setMouldStatus(MouldStatus.USABLE.getCode());
            if (noticeItem.getDesignedLifetime() == null) {
                mould.setDesignedLifetime(new BigDecimal(0));
            }
            if (mould.getUsedLifetime() == null) {
                mould.setUsedLifetime(new BigDecimal(0));
            }
            mould.setOverplusLifetime(mould.getDesignedLifetime().subtract(mould.getUsedLifetime()).setScale(2, 4));
            this.completeMouldSupAndPur(mould, mouldNotice);
            this.mouldService.addObj(mould);
        }
    }

    private void completeinfo(MouldNotice mouldNotice, NoticeItem noticeItem, Mould mould) {
        mould.setConcertQuality(noticeItem.getMaterialQuality());
        mould.setMouldTime(noticeItem.getReceiveMouldDate());
        mould.setMouldNoticeNo(mouldNotice.getNoticeNo());
        mould.setMouldNoticeItemNo(noticeItem.getItemNo());
        mould.setPropertyRight(mouldNotice.getCompanyName());
        mould.setMouldNumber(noticeItem.getItemNo());
    }

    private void completeMouldSupAndPur(Mould mould, MouldNotice mouldNotice) {
        mould.setPurCompanyId(mouldNotice.getPurCompanyId());
        mould.setPurCompanyFullName(mouldNotice.getPurCompanyFullName());
        mould.setPurCompanyName(mouldNotice.getPurCompanyName());
        mould.setPurCompanySrmCode(mouldNotice.getPurCompanySrmCode());
        Company mouCompany = this.companyService.queryCompanyBySapCode(mouldNotice.getMouldSupCompanySapCode());
        mould.setMouldSupCompanyId(mouCompany.getId());
        mould.setMouldSupCompanySapCode(mouCompany.getCompanySapCode());
        mould.setMouldSupCompanyName(mouCompany.getCompanyName());
        mould.setMouldSupCompanySrmCode(mouCompany.getCompanyCode());
        mould.setMouldSupCompanyFullName(mouCompany.getCompanyFullName());
        Company conCompany = this.companyService.queryCompanyBySapCode(mouldNotice.getConceiveSupCompanySapCode());
        mould.setConceiveSupCompanyId(conCompany.getId());
        mould.setConceiveSupCompanyName(conCompany.getCompanyName());
        mould.setConceiveSupCompanySapCode(conCompany.getCompanySapCode());
        mould.setConceiveSupCompanyFullName(conCompany.getCompanyFullName());
        mould.setMouldSupCompanySrmCode(conCompany.getCompanyCode());
    }

    @Override
    @Transactional
    @CacheEvict(value={"mouldNotice"}, allEntries=true)
    public void deleteObjByIds(List<String> ids) {
        NoticeItemExample example = new NoticeItemExample();
        example.createCriteria().andIdNotIn((List)ids);
        List<NoticeItem> items = this.noticeItemMapper.selectByExample(example);
        Assert.isNotEmpty(items, (String)"\u5f00\u6a21\u901a\u77e5\u5355\u884c\u9879\u4e0d\u80fd\u4e3a\u7a7a,\u5220\u9664\u5931\u8d25");
        example.clear();
        example.createCriteria().andIdIn((List)ids);
        List<NoticeItem> noticeItems = this.noticeItemMapper.selectByExample(example);
        Assert.isNotEmpty(noticeItems, (String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5f00\u6a21\u901a\u77e5\u5355\u884c\u9879");
        MouldNoticeExample example2 = new MouldNoticeExample();
        example2.createCriteria().andNoticeNoEqualTo(noticeItems.get(0).getNoticeNo());
        List notices = this.mouldNoticeService.queryAllObjByExample((IExample)example2);
        Assert.isNotEmpty((Collection)notices, (String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u5f00\u6a21\u901a\u77e5\u5355");
        MouldNotice mouldNotice = (MouldNotice)notices.get(0);
        if (Constant.YES_INT.equals(mouldNotice.getSendStatus())) {
            throw new CommonException("\u8be5\u901a\u77e5\u5355\u5df2\u53d1\u9001,\u4e0d\u5141\u8bb8\u5220\u9664!");
        }
        for (NoticeItem item : noticeItems) {
            item.setId(item.getId());
            item.setIsEnable("N");
            this.noticeItemMapper.updateByPrimaryKeySelective(item);
        }
    }
}

