/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.roller.master.command;

import com.els.base.company.entity.Company;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.roller.entity.RollerNoticeItemExample;
import com.els.base.mould.roller.master.entity.Roller;
import com.els.base.mould.roller.master.entity.RollerExample;
import com.els.base.mould.roller.master.utils.RollerStatus;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class CreateCommand
extends AbstractMouldCommand<String> {
    private Roller roller;

    public CreateCommand(Roller roller) {
        this.roller = roller;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        this.valiad(this.roller);
        this.init(this.roller);
        this.mouldInvorker.getRollerService().addObj(this.roller);
        return null;
    }

    private void init(Roller roller) {
        this.completeSupAndPur();
        this.completeinfo();
    }

    private void completeinfo() {
        String plateNo = this.roller.getPlateNo();
        RollerExample example = new RollerExample();
        example.createCriteria().andPlateIdLike(plateNo + "___");
        int i = this.mouldInvorker.getRollerService().countByExample(example);
        RollerNoticeItemExample example2 = new RollerNoticeItemExample();
        example2.createCriteria().andRollerIdLike(plateNo + "___");
        int j = this.mouldInvorker.getRollerNoticeItemService().countByExample(example2);
        String id = String.format("%s%03d", plateNo, i + j + 1);
        this.roller.setPlateId(id);
        this.roller.setId(UUIDGenerator.generateUUID());
        this.roller.setProjectId(this.getPurCompany().getProjectId());
        this.roller.setCreateTime(new Date());
        this.roller.setCreateName(this.getPurUser().getNickName());
        this.roller.setIsEnable(Constant.YES_INT);
        if (this.roller.getPlateStats() == null) {
            this.roller.setPlateStats(RollerStatus.USABLE.getCode());
        }
        if (this.roller.getDesignedLifetime() == null) {
            this.roller.setDesignedLifetime(new BigDecimal(0));
        }
        if (this.roller.getUserLifetime() == null) {
            this.roller.setUserLifetime(new BigDecimal(0));
        }
        BigDecimal subtract = this.roller.getDesignedLifetime().subtract(this.roller.getUserLifetime()).setScale(2, 4);
        this.roller.setSurplusLifetime(subtract);
        this.roller.setDateUnit("s");
        if (StringUtils.isEmpty((String)this.roller.getPropertyRightStatus())) {
            this.roller.setPropertyRightStatus(this.roller.getCompanyName());
        }
    }

    private void completeSupAndPur() {
        Company purCompany = this.getPurCompany();
        this.roller.setPurCompanyId(purCompany.getId());
        this.roller.setPurCompanySapCode(purCompany.getCompanySapCode());
        this.roller.setPurCompanySrmCode(purCompany.getCompanyCode());
        this.roller.setPurCompanyFullName(purCompany.getCompanyFullName());
        this.roller.setPurCompanyName(purCompany.getCompanyName());
        Company plateCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(this.roller.getPlateSupCompanySapCode());
        this.roller.setPlateSupCompanyId(plateCompany.getId());
        this.roller.setPlateSupCompanySrmCode(plateCompany.getCompanyCode());
        this.roller.setPlateSupCompanyName(plateCompany.getCompanyName());
        Company conCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(this.roller.getConceiveSupCompanySapCode());
        this.roller.setConceiveSupCompanyId(conCompany.getId());
        this.roller.setConceiveSupCompanySrmCode(conCompany.getCompanyCode());
        this.roller.setConceiveSupCompanyName(conCompany.getCompanyName());
    }

    private void valiad(Roller roller) {
        Assert.isNotBlank((String)roller.getCompanyCode(), (String)"\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)roller.getPlateSupCompanySapCode(), (String)"\u7248\u8f8a\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)roller.getConceiveSupCompanySapCode(), (String)"\u6301\u6709\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)roller.getPlateNo(), (String)"\u7248\u8f8a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)roller.getPlateDesc(), (String)"\u7248\u8f8a\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)roller.getPlateStats(), (String)"\u7248\u8f8a\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)roller.getDesignCapacity(), (String)"\u8bbe\u8ba1\u65e5\u4ea7\u80fd\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

