/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.roller.master.command;

import com.els.base.company.entity.Company;
import com.els.base.core.utils.Assert;
import com.els.base.mould.common.AbstractMouldCommand;
import com.els.base.mould.common.MouldInvorker;
import com.els.base.mould.roller.master.entity.Roller;
import java.math.BigDecimal;
import java.util.Date;

public class ModifyCommand
extends AbstractMouldCommand<String> {
    private Roller roller;

    public ModifyCommand(Roller roller) {
        this.roller = roller;
    }

    @Override
    public String execute(MouldInvorker mouldInvorker) {
        this.valiad(this.roller);
        this.complete(this.roller);
        this.mouldInvorker.getRollerService().modifyObj(this.roller);
        return null;
    }

    private void complete(Roller roller) {
        this.completeSupAndPur();
        this.completeinfo();
    }

    private void completeinfo() {
        this.roller.setUpdateTime(new Date());
        this.roller.setUpdateUser(this.getPurUser().getNickName());
        if (this.roller.getDesignedLifetime() == null) {
            this.roller.setDesignedLifetime(new BigDecimal(0));
        }
        if (this.roller.getUserLifetime() == null) {
            this.roller.setUserLifetime(new BigDecimal(0));
        }
        BigDecimal subtract = this.roller.getDesignedLifetime().subtract(this.roller.getUserLifetime()).setScale(2, 4);
        this.roller.setSurplusLifetime(subtract);
    }

    private void completeSupAndPur() {
        Company plateCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(this.roller.getPlateSupCompanySapCode());
        this.roller.setPlateSupCompanyId(plateCompany.getId());
        this.roller.setPlateSupCompanySrmCode(plateCompany.getCompanyCode());
        this.roller.setPlateSupCompanyName(plateCompany.getCompanyName());
        Company conCompany = this.mouldInvorker.getCompanyService().queryCompanyBySapCode(this.roller.getConceiveSupCompanySapCode());
        this.roller.setConceiveSupCompanyId(conCompany.getId());
        this.roller.setConceiveSupCompanySrmCode(conCompany.getCompanyCode());
        this.roller.setConceiveSupCompanyName(conCompany.getCompanyName());
    }

    private void valiad(Roller roller) {
        Assert.isNotBlank((String)roller.getCompanyCode(), (String)"\u516c\u53f8\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)roller.getPlateSupCompanySapCode(), (String)"\u7248\u8f8a\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)roller.getConceiveSupCompanySapCode(), (String)"\u6301\u6709\u4f9b\u5e94\u5546SAP\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)roller.getPlateNo(), (String)"\u7248\u8f8a\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)roller.getPlateDesc(), (String)"\u7248\u8f8a\u63cf\u8ff0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)roller.getPlateStats(), (String)"\u7248\u8f8a\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)roller.getDesignCapacity(), (String)"\u8bbe\u8ba1\u65e5\u4ea7\u80fd\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

