/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.mould.roller.scrap.service.impl;

import com.els.base.company.service.CompanyUserRefService;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.mould.roller.master.entity.Roller;
import com.els.base.mould.roller.master.entity.RollerExample;
import com.els.base.mould.roller.master.service.RollerService;
import com.els.base.mould.roller.master.utils.RollerStatus;
import com.els.base.mould.roller.scrap.dao.RollerScrapMapper;
import com.els.base.mould.roller.scrap.entity.RollerScrap;
import com.els.base.mould.roller.scrap.entity.RollerScrapExample;
import com.els.base.mould.roller.scrap.service.RollerScrapService;
import com.els.base.mould.roller.scrap.utils.ConfirmStatus;
import com.els.base.mould.roller.utlis.RollerBusinessEnum;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultRollerScrapService")
public class RollerScrapServiceImpl
implements RollerScrapService {
    @Resource
    protected RollerScrapMapper rollerScrapMapper;
    @Resource
    protected RollerService rollerService;
    @Resource
    private CompanyUserRefService companyUserRefService;
    @Resource
    private ThreadPoolTaskExecutor defaultThreadPool;

    @CacheEvict(value={"rollerScrap"}, allEntries=true)
    public void addObj(RollerScrap t) {
        this.rollerScrapMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"rollerScrap"}, allEntries=true)
    public void addAll(List<RollerScrap> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.rollerScrapMapper.insertBatch(list);
    }

    @CacheEvict(value={"rollerScrap"}, allEntries=true)
    public void deleteObjById(String id) {
        this.rollerScrapMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"rollerScrap"}, allEntries=true)
    public void deleteByExample(RollerScrapExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.rollerScrapMapper.deleteByExample(example);
    }

    @CacheEvict(value={"rollerScrap"}, allEntries=true)
    public void modifyObj(RollerScrap t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.rollerScrapMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"rollerScrap"}, keyGenerator="redisKeyGenerator")
    public RollerScrap queryObjById(String id) {
        return this.rollerScrapMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"rollerScrap"}, keyGenerator="redisKeyGenerator")
    public List<RollerScrap> queryAllObjByExample(RollerScrapExample example) {
        return this.rollerScrapMapper.selectByExample(example);
    }

    @Cacheable(value={"rollerScrap"}, keyGenerator="redisKeyGenerator")
    public PageView<RollerScrap> queryObjByPage(RollerScrapExample example) {
        PageView<RollerScrap> pageView = example.getPageView();
        pageView.setQueryResult(this.rollerScrapMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Transactional
    @CacheEvict(value={"rollerScrap"}, allEntries=true)
    public void confirmToPur(List<String> ids, final User loginUser) {
        RollerScrapExample example = new RollerScrapExample();
        example.createCriteria().andIdIn((List)ids);
        List<RollerScrap> scrapList = this.rollerScrapMapper.selectByExample(example);
        Assert.isNotEmpty(scrapList, (String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u62a5\u5e9f\u5355");
        for (RollerScrap rollerScrap : scrapList) {
            if (Constant.NO_INT.equals(rollerScrap.getSendStatus())) {
                throw new CommonException("\u62a5\u5e9f\u5355" + rollerScrap.getBillNo() + "\u672a\u53d1\u9001\uff0c\u4e0d\u5141\u8bb8\u786e\u8ba4");
            }
            if (Constant.YES_INT.equals(rollerScrap.getConfirmStatus())) {
                throw new CommonException("\u62a5\u5e9f\u5355" + rollerScrap.getBillNo() + "\u5df2\u786e\u8ba4\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u786e\u8ba4");
            }
            rollerScrap.setConfirmStatus(ConfirmStatus.SCRAP_PUR_CONFIRM.getCode());
            rollerScrap.setConfirmTime(new Date());
            if (rollerScrap.getScrappingTime() == null) {
                rollerScrap.setScrappingTime(new Date());
            }
            rollerScrap.setPlateStats(RollerStatus.ABLOISH.getCode());
            this.rollerScrapMapper.updateByPrimaryKeySelective(rollerScrap);
            RollerExample example2 = new RollerExample();
            example2.createCriteria().andPlateIdEqualTo(rollerScrap.getPlateId());
            List rollers = this.rollerService.queryAllObjByExample((IExample)example2);
            Assert.isNotEmpty((Collection)rollers, (String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u7248\u8f8a\u4e3b\u6570\u636e");
            for (Roller roller : rollers) {
                roller.setId(roller.getId());
                roller.setPlateStats(RollerStatus.ABLOISH.getCode());
                if (rollerScrap.getScrappingTime() == null) {
                    roller.setScrapTime(new Date());
                } else {
                    roller.setScrapTime(rollerScrap.getScrappingTime());
                }
                this.rollerService.modifyObj(roller);
            }
        }
        List<RollerScrap> list = this.queryAllObjByExample(example);
        for (final RollerScrap rollerScrap : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    RollerScrapServiceImpl.this.sendMessagesToSup(loginUser, rollerScrap, RollerBusinessEnum.ROLLER_SCRAP_CONFIRM.getCode());
                }
            });
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"rollerScrap"}, allEntries=true)
    public void deleteByIds(List<String> ids, User loginUser) {
        RollerScrapExample example = new RollerScrapExample();
        example.createCriteria().andIdIn((List)ids);
        List<RollerScrap> scrapList = this.rollerScrapMapper.selectByExample(example);
        Assert.isNotEmpty(scrapList, (String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u62a5\u5e9f\u5355");
        for (RollerScrap rollerScrap : scrapList) {
            if (Constant.YES_INT.equals(rollerScrap.getSendStatus())) {
                throw new CommonException("\u62a5\u5e9f\u5355" + rollerScrap.getBillNo() + "\u5df2\u53d1\u9001\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
            }
            rollerScrap.setId(rollerScrap.getId());
            rollerScrap.setIsEnable("Y");
            this.modifyObj(rollerScrap);
        }
    }

    @Override
    @Transactional
    @CacheEvict(value={"rollerScrap"}, allEntries=true)
    public void sendToPur(List<String> ids, final User loginUser) {
        RollerScrapExample example = new RollerScrapExample();
        example.createCriteria().andIdIn((List)ids);
        List<RollerScrap> scrapList = this.rollerScrapMapper.selectByExample(example);
        Assert.isNotEmpty(scrapList, (String)"\u672a\u627e\u5230\u76f8\u5e94\u7684\u62a5\u5e9f\u5355");
        for (RollerScrap rollerScrap : scrapList) {
            if (Constant.YES_INT.equals(rollerScrap.getIsEnable())) {
                throw new CommonException("\u62a5\u5e9f\u5355" + rollerScrap.getBillNo() + "\u5df2\u88ab\u5220\u9664\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c");
            }
            if (Constant.YES_INT.equals(rollerScrap.getSendStatus())) {
                throw new CommonException("\u62a5\u5e9f\u5355" + rollerScrap.getBillNo() + "\u5df2\u53d1\u9001\uff0c\u4e0d\u8fd0\u884c\u64cd\u4f5c");
            }
            rollerScrap.setId(rollerScrap.getId());
            rollerScrap.setSendStatus(Constant.YES_INT);
            rollerScrap.setSendTime(new Date());
            rollerScrap.setApplyUserName(loginUser.getNickName());
            rollerScrap.setApplyTime(new Date());
            this.modifyObj(rollerScrap);
        }
        List<RollerScrap> list = this.queryAllObjByExample(example);
        for (final RollerScrap rollerScrap : list) {
            this.defaultThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    RollerScrapServiceImpl.this.sendMessagesToPur(loginUser, rollerScrap, RollerBusinessEnum.ROLLER_SCRAP_SEND.getCode());
                }
            });
        }
    }

    protected void sendMessagesToPur(User loginUser, RollerScrap data, String businessType) {
        User purUser = this.companyUserRefService.queryMainUserOfCompany(data.getPurCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(purUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }

    protected void sendMessagesToSup(User loginUser, RollerScrap data, String businessType) {
        User supUser = this.companyUserRefService.queryMainUserOfCompany(data.getConceiveSupCompanyId());
        Message message = Message.init((Object)data).setBusinessTypeCode(businessType).setCompanyCode(data.getPurCompanySrmCode()).setMsgLevel(MessageLevelEnum.HIGH).setSenderId(loginUser.getId()).addReceiverId(supUser.getId());
        MessageSendUtils.sendMessage((Message)message);
    }
}

